(function() {
    var DEFAULT_MONTH = '13';

    passport.block('registration-date', 'control', {
        needsServerValidation: false,
        isRequired: true,
        updateTimeout: 0,

        isEmpty: function() {
            return this.val() === '-' + DEFAULT_MONTH + '-';
        },

        normalize: function() {},

        val: function() {
            return [
                this.normalize(this.$('input[name="ryear"]').val(), true),
                this.normalize(this.$('select[name="rmonth"]').val()),
                this.normalize(this.$('input[name="rday"]').val())
            ].join('-');
        },

        maxYear: new Date().getFullYear(),
        minYear: 2000,
        maxMonth: new Date().getMonth() + 1,
        maxDay: new Date().getDate(),

        validate: function(suppressError) {
            var val = this.val();
            var year = val.split('-')[0];

            if (year === '0000') {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            if (isNaN(year) || year > this.maxYear) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            if (year < this.minYear) {
                this.validationResult(false, 'tooearly', suppressError);
                return;
            }

            var month = parseInt(val.split('-')[1], 10);

            if (year === this.maxYear && month !== DEFAULT_MONTH && month > this.maxMonth) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            var day = Number(val.split('-')[2]);

            if (isNaN(day)) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            if (year === this.maxYear && month === this.maxMonth && day && day > this.maxDay) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            if (year && month && day && !passport.util.isCorrectDate(val)) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            this.validationResult(true, null, false);
            return;
        },

        init: function() {
            this.normalize = passport.block('birthday').normalize;
        }
    });
})();
