/* borschik:include:../suggest/suggestMixin.js */

/* borschik:include:additional-email/additional-email.js */
/* borschik:include:registration-date/registration-date.js */
/* borschik:include:registration-city/registration-city.js */
/* borschik:include:registration-country/registration-country.js */
/* borschik:include:last-passwords/last-passwords.js */
/* borschik:include:real-reason/real-reason.js */
/* borschik:include:last-auth/last-auth.js */
/* borschik:include:social-profiles/social-profiles.js */
/* borschik:include:feedback-email/feedback-email.js */
/* borschik:include:user-enabled/user-enabled.js */
/* borschik:include:questions/questions.js */
/* borschik:include:answers/answers.js */
/* borschik:include:address/address.js */
/* borschik:include:phones/phones.js */
/* borschik:include:contact-reason/contact-reason.js */
/* borschik:include:mail/mail.js */
/* borschik:include:attach/attach.js */
/* borschik:include:services/services.js */
/* borschik:include:../checkbox/eula-confidential/eula-confidential.js */

(function() {
    passport.block('multiply-fields', {
        events: {
            'change .js-control__field_trigger input': 'onTogglerUpdate',
            'click .js-button_plus': 'cloneField'
        },

        revalidate: function() {
            var controls = $.map(passport.blocks, function(block) {
                return block;
            });

            controls = $.map(controls, function(control) {
                if (control.inited.already) {
                    return control;
                }

                return null;
            });

            $.map(controls, function(control) {
                if (typeof control.validate === 'function') {
                    if (!control.isEmpty()) {
                        return control.validate();
                    }
                }

                return null;
            });
        },

        onTogglerUpdate: function(event) {
            var self = event.currentTarget;
            var id = self && $(self).data('field-id');
            var field = id && $('.js-control__field_' + id);

            if (!field) {
                return;
            }

            var maxFieldsCount = $('.js-button_plus', field).data('max-count');

            if ($(self).is(':checked')) {
                $('input, select, .js-button_plus, .p-control__select', field)
                    .addClass('is-disabled')
                    .attr('disabled', true);
            } else {
                $('input, select, .p-control__select', field)
                    .removeClass('is-disabled')
                    .attr('disabled', false);

                if ($('input', field).length !== maxFieldsCount) {
                    $('js-button_plus', field)
                        .removeClass('is-disabled')
                        .attr('disabled', false);
                }
            }

            this.revalidate();
        },

        cloneField: function(event) {
            var self = event.currentTarget;
            var id = self && $(self).data('field-id');
            var field = id && $('#' + id);

            if (!field) {
                return;
            }

            var maxFieldsCount = (self && $(self).data('max-count')) || 0;
            var fields = this.$('input[name="' + field.attr('name') + '"]');

            if (fields.length >= maxFieldsCount - 1) {
                $(self)
                    .addClass('is-disabled')
                    .attr('disabled', true);
            }

            if (fields.length >= maxFieldsCount) {
                return;
            }

            fields.removeClass('p-control__last_input');
            var clone = field
                .clone()
                .val('')
                .removeAttr('id')
                .addClass('p-control__last_input');

            this.$('.js-control__field_' + id)
                .find('.p-control__button_plus_wrap')
                .before(clone);

            this.$('.js-control__field_' + id)
                .find('.p-control__last_input')
                .focus();
        }
    });
})();
