var Field = require('pform/Field');

module.exports = require('inherit')(Field, {
    __constructor: function() {
        this._init('services')
            .setLabel('%semiauto.services')
            .setHint('%semiauto.services-note')
            .addError(new Field.Error('missingvalue', '%services_errors_missingvalue'));

        this._services = [];
    },

    setServices: function(data) {
        this._services = data || [];
    },

    compile: function(lang) {
        var compiled = this.__base.call(this, lang);

        this._services.forEach(function(service) {
            service.label = require('putils').i18n(lang, service.label);
        });

        compiled.services = this._services;
        return compiled;
    }
});
