/* borschik:include:../../../social/broker.js */

(function() {
    passport.block('social-profiles', 'control', {
        needsServerValidation: false,
        updateTimeout: 0,
        isRequired: false,

        _brokerParams: {
            place: 'fragment'
        },
        _avatarParams: {
            avatar_size_x: 35,
            avatar_size_y: 35
        },
        _profiles: [],
        _taskIds: [],
        _viewName: 'restore.semiauto',

        events: {
            'click .js-social-button': 'socialAuth',
            'click .js-profile-delete': 'deleteProfile'
        },

        checkLimit: function() {
            this.toggleDisableButtons(this._profiles.length >= this.options.limit);
        },

        brokerOnSuccess: function(data) {
            if (!data.task_id) {
                return;
            }

            this.getDataByTask(data.task_id);
        },

        brokerOnFailure: function() {},

        setupBroker: function() {
            var self = this;

            this._brokerParams.startUrl = '/auth/social/start_restoration';
            this.broker = passport.block('broker');
            this.broker.init(this._brokerParams);

            if (window.addEventListener) {
                window.addEventListener('message', self.socialAuthResponseHendle.bind(self), false);
            } else {
                window.attachEvent('onmessage', self.socialAuthResponseHendle.bind(self));
            }

            window.socialResponse = function(data) {
                self.socialAuthResponseHendle({
                    // eslint-disable-next-line compat/compat
                    origin: location.origin,
                    data: data
                });
            };
        },

        socialAuthResponseHendle: function(event) {
            var params = event.data;

            // eslint-disable-next-line compat/compat
            if (event.origin !== location.origin) {
                return;
            }

            if (!params || !params.socialAuth) {
                return;
            }

            if (params.status === 'ok') {
                this.brokerOnSuccess(params);
            } else {
                this.brokerOnFailure(params);
            }
        },

        socialAuth: function(event) {
            event.preventDefault();
            var elem = $(event.currentTarget);
            var provider = elem.data('provider');

            if (provider) {
                this.broker.start({
                    provider: provider
                });

                elem.blur();
            }
        },

        providerName: {
            vkontakte: i18n('%vkontakte'),
            facebook: i18n('%facebook'),
            twitter: i18n('%twitter'),
            mailru: i18n('%mailru'),
            google: i18n('%google'),
            odnoklassniki: i18n('%odnoklassniki'),
            lastfm: i18n('%lastfm')
        },

        containsProfile: function(current) {
            var has = false;

            if (this._profiles.length) {
                this._profiles.forEach(function(profile) {
                    if (profile.username === current.username && profile.provider.code === current.provider.code) {
                        has = true;
                    }
                });
            }

            return has;
        },

        getDataByTask: function(task) {
            var self = this;

            passport.api
                .request(this.id, $.extend({}, {task_id: task}, this._avatarParams), {
                    cache: true
                })
                .done(function(data) {
                    if (data && data.thumbnail) {
                        var current = data.thumbnail;

                        if (self.containsProfile(current)) {
                            return;
                        }

                        if (current.provider && current.provider.name) {
                            current.provider.localizeName = self.providerName[current.provider.name] || '';
                        }

                        current.taskId = task;

                        self._profiles.push(current);
                        self.checkLimit();
                        self.repaintAccounts();
                    }
                });
        },

        repaintAccounts: function() {
            this.$('.js-profiles').html(yr.run(this._viewName, {profiles: this._profiles}, 'profiles'));
        },

        deleteProfile: function(event) {
            var taskId = $(event.target).data('id');

            this._profiles = this._profiles.filter(function(profile) {
                return profile.taskId !== taskId;
            });

            this.checkLimit();
            this.repaintAccounts();
        },

        toggleDisableButtons: function(disable) {
            this.$('.js-social-button')
                .attr('disable', disable)
                .toggleClass('is-disabled', disable);
        },

        init: function() {
            this.setupBroker();
        }
    });
})();
