(function() {
    //TODO: how do I show which fields aren't filled?
    passport.block('submit', 'control', {
        needsServerValidation: false,
        events: {
            'click button': 'check'
        },

        isEmpty: function() {
            return false;
        },

        /**
         * Array of control id's to check.
         * If set, only these controls would be checked.
         * All controls would be checked otherwise.
         *
         * @type string[]
         */
        controlsToCheck: null,

        check: function(event, silent) {
            //Do not send the form implicitly
            if (event) {
                event.preventDefault();
            }

            //Make sure the controls are inited
            //in case we're checking all existent controls, all controls are available,
            //but only those used in a page are inited

            var controls = $.map(this.getAffectedControls(), function(control) {
                if (control.inited.already) {
                    return control;
                }

                return null;
            });

            //Revalidate all the controls, that can be validated
            var validations = $.map(controls, function(control) {
                if (typeof control.validate === 'function') {
                    return control.validate(true);
                }

                return null;
            });

            var that = this;

            $.when.apply(null, validations).always(function() {
                //When the controls are validated, check if any are invalid
                var anyInvalid = controls.some(function(control) {
                    return passport.validator.check(control) === false;
                });

                if (anyInvalid) {
                    if (!silent) {
                        that.onInvalid(event);
                    }
                } else {
                    that.onValid(event);
                }
            });
        },

        /**
         * Determine affected controls, specific or all
         * @returns {Control[]}
         */
        getAffectedControls: function() {
            return !$.isArray(this.controlsToCheck)
                ? $.map(passport.blocks, function(block) {
                      if (block.isControl && block.inited.already) {
                          return block;
                      }

                      return null;
                  })
                : $.map(this.controlsToCheck, function(blockName) {
                      return passport.block(blockName);
                  });
        },

        onValid: function() {
            this.onSubmit();

            //Send the form explicitly
            this.emit('onSubmit');
            this.$el.closest('form').submit();
            this.disable();
        },

        onInvalid: function() {
            this.getAffectedControls().forEach(function(control) {
                if (typeof control.validate === 'function') {
                    control.validate();
                }
            });
        },

        onSubmit: function() {
            /* jshint unused:false */
        },

        disable: function() {
            if (this.nbctrl && typeof this.nbctrl.disable === 'function') {
                this.nbctrl.disable();
            } else {
                this.$('button[type=submit]').attr('disabled', true);
            }
        },

        enable: function() {
            if (this.nbctrl && typeof this.nbctrl.enable === 'function') {
                this.nbctrl.enable();
            } else {
                this.$('button[type=submit]').removeAttr('disabled');
            }
        }
    });
})();
