(function() {
    passport.defineMixin('suggest', {
        events: {
            'click .js-suggest_item': 'getItem',
            'keyup .js-suggest_trigger': 'onKeyUp',
            'keydown .js-suggest_trigger': 'onKeyDown'
        },

        init: function() {
            $(document).on('click', this.hideSuggest.bind(this));
            this.suggest = this.$('.js-suggest_data');
        },

        clear: function() {
            this.suggest.html('');
            this.$('input[type="hidden"]').val('');
        },

        showSuggest: function() {
            this.suggest.removeClass('g-hidden');
            this.$el.addClass('b-suggest_zindex');
        },

        hideSuggest: function(event) {
            if (event && this.testElem(event)) {
                return;
            }

            this.suggest.addClass('g-hidden');
            this.$el.removeClass('b-suggest_zindex');
        },

        testElem: function(e) {
            return (
                /b-suggest/.test(e.target.className) ||
                $(e.target)
                    .parents()
                    .hasClass('b-suggest')
            );
        },

        getValue: function() {
            var selectedItem = this.$('.b-suggest_item_selected');

            return {
                name: selectedItem.data('name'),
                id: selectedItem.data('code')
            };
        },

        setValue: function() {
            var val = this.getValue();

            this.$('input[type="text"]').val(val.name);
            this.$('input[type="hidden"]').val(val.id);
        },

        getItem: function(event) {
            this.$('.b-suggest_item_selected').removeClass('b-suggest_item_selected');
            $(event.currentTarget).addClass('b-suggest_item_selected');

            this.setValue();
            this.hideSuggest();
            this.$('input[type="text"]').focus();
        },

        onKeyUp: function(event) {
            var code = passport.util.getKeyCode(event);

            if (
                !event.ctrlKey &&
                !event.metaKey &&
                !event.altKey &&
                !/\w/.test(String.fromCharCode(code)) &&
                [passport.util.keymap.backspace, passport.util.keymap.cmd, passport.util.keymap['webkit-cmd']].indexOf(
                    code
                ) === -1
            ) {
                return;
            }

            if (this.getSuggestData && typeof this.getSuggestData === 'function') {
                this.getSuggestData();
            }
        },

        onKeyDown: function(event) {
            var code = passport.util.getKeyCode(event);

            if (code === passport.util.keymap.tab) {
                this.hideSuggest();
            }

            if (
                [passport.util.keymap.enter, passport.util.keymap.up, passport.util.keymap.down].indexOf(code) === -1 ||
                !this.suggest.is(':visible')
            ) {
                return;
            }

            event.preventDefault();
            var selected = this.$('.b-suggest_item_selected', this.suggest);

            if (code === passport.util.keymap.enter) {
                if (selected.length) {
                    this.hideSuggest();
                }
                return;
            }

            var dir = code === passport.util.keymap.up ? 0 : 1;
            var nextItem;

            if (dir) {
                if (selected.length && selected.next().length) {
                    nextItem = selected.next();
                } else {
                    nextItem = this.$('.js-suggest_item:first');
                }
            } else {
                if (selected.length && selected.prev().length) {
                    nextItem = selected.prev();
                } else {
                    nextItem = this.$('.js-suggest_item:last');
                }
            }

            if (selected.length) {
                selected.removeClass('b-suggest_item_selected');
            }

            nextItem.addClass('b-suggest_item_selected');
            this.setValue();
        },

        // \x21-\x2C\x2E-\x40\x5B-\x60\x7B-\x7E == !"#$%&'()*+,.0123456789:;<=>?@[]\^_`{|}~
        // валидными считаются только словестные символы и дефисы не в начале или конце строки
        validateRegExp: /^-|-$|[\x21-\x2C\x2E-\x40\x5B-\x60\x7B-\x7E/]/,

        validate: function(suppressError) {
            if (this.isRequired && this.isEmpty()) {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            if (this.validateRegExp.test(passport.util.normalize(this.val()))) {
                this.validationResult(false, 'invalid', suppressError);
                return;
            }

            this.validationResult(true, null, false);
            return;
        }
    });
})();
