(function() {
    // eslint-disable-next-line no-useless-escape
    var NOT_PHONE_SYMBOL = /^[^\+\d]?|[^\d]+/g;

    passport.block('switch-login-phone', 'control', {
        updateTimeout: 0, //Disable watching
        controlSelector: '.js-switch-login-phone',
        isOriginInput: true,

        init: function() {
            this.$loginPreset = this.$('.js-switch-login-phone_login');
            this.$phoneConfirm = this.$('.js-switch-login-phone_phone');

            this.subBlocks = {
                loginPreset: passport.block('login-preset'),
                phoneConfirm: passport.block('phone-confirm')
            };

            var phoneConfirmEntry = passport.block('phone-confirm-entry');

            phoneConfirmEntry.inited.then(function() {
                if (!phoneConfirmEntry.$ctrl.is('input')) {
                    phoneConfirmEntry.$ctrl = phoneConfirmEntry.$ctrl.find('input');
                }
                phoneConfirmEntry.updateMask();
            });
        },

        /**
         * Validate the switch-login-phone. It
         * * Checks the switch value: either 'login' or 'phone'
         * * Validates the children
         *
         * @param {boolean} [suppressError]
         * @param {boolean} [passive=false]
         * Whether the block should be actively checked, or validation value should be fetched from the store
         */
        validate: function(suppressError, passive) {
            var check = passive
                ? function(block) {
                      //Block is checked against validator
                      var deferred = new $.Deferred();

                      deferred.resolve(passport.validator.check(block));
                      return deferred;
                  }
                : function(block) {
                      //Block is actively validated
                      return block.validate(suppressError);
                  };

            var that = this;
            var resultDeferred = new $.Deferred();

            var blockName = 'login-preset';
            var phoneModel = this.subBlocks.phoneConfirm.getModel();

            if (!this.isLoginState() && !(phoneModel && phoneModel.isConfirmed())) {
                blockName = 'phone-confirm';
            }
            if (passport.block(blockName).inited.already) {
                check(passport.block(blockName)).then(function(result) {
                    that.emit('validation', result);
                    resultDeferred.resolve(result);
                });
            } else {
                resultDeferred.resolve(true);
            }

            return resultDeferred;
        },

        events: {
            'validation.login': 'switcherLoginPhone',
            'validation.phone-confirm': 'switcherLoginPhone',
            'phoneConfirmed.phone-confirm': 'showLoginPreset',
            'maskBeginWithLetter.phone-confirm-entry': 'switchToLoginWithPhoneValue'
        },

        switchToLoginWithPhoneValue: function(event, valuePhoneField) {
            // eslint-disable-next-line no-useless-escape
            this.switchToLogin(valuePhoneField.replace(/[\s\(\)]+/g, ''));
        },

        showLoginPreset: function() {
            this.$phoneConfirm.addClass('p-control_validated');

            if (this.isLoginState()) {
                return;
            }

            this.subBlocks.loginPreset.val('');
            this.subBlocks.loginPreset.init();
            this.$loginPreset.removeClass('g-hidden');

            this.forcerNodeRepaint(this.$loginPreset);
        },

        switcherLoginPhone: function(event, b, errorCode) {
            if (!this.isSubBlocksInited()) {
                return;
            }

            this.checkValidation(event, b);

            errorCode = errorCode || '';
            if (
                this.isLoginState() &&
                this.subBlocks.phoneConfirm.isEmpty() &&
                this.checkPhoneNumber(errorCode, this.subBlocks.loginPreset.val())
            ) {
                this.switchToPhone();
                return;
            }

            if (!this.isLoginState() && this.subBlocks.phoneConfirm.isEmpty()) {
                this.switchToLogin();
            }
        },

        checkPhoneNumber: function(errorCode, value) {
            return errorCode === 'startswithdigit' || (errorCode === 'prohibitedsymbols' && value.indexOf('+') === 0);
        },

        switchToPhone: function() {
            this.onSwitchToPhone();

            this.subBlocks.phoneConfirm.error();
            this.subBlocks.loginPreset.error();

            this.$loginPreset.addClass('g-hidden');
            this.$phoneConfirm.removeClass('g-hidden');

            this.subBlocks.phoneConfirm.focus();
            this.subBlocks.phoneConfirm.val(this.subBlocks.loginPreset.val().replace(NOT_PHONE_SYMBOL, ''));
            this.subBlocks.phoneConfirm.updatePhoneMask();

            this.emit('showPhone');

            this.val('phone');
            this.validate(true); //To revalidate the subblocks
        },

        isSubBlocksInited: function() {
            return this.subBlocks.loginPreset.inited.already && this.subBlocks.phoneConfirm.inited.already;
        },

        switchToLogin: function(newValue) {
            this.onSwitchToLogin();

            this.subBlocks.phoneConfirm.error();
            this.subBlocks.loginPreset.error();
            // TODO: при переключение оставалась справка о валидном логине
            // получилось убрать только руками, нужно будет поправить
            this.subBlocks.loginPreset.loginBlock.loginRequirements.addClass('g-hidden');
            this.subBlocks.loginPreset.val(newValue || '');

            this.$phoneConfirm.addClass('g-hidden');
            this.$loginPreset.removeClass('g-hidden');

            this.forcerNodeRepaint(this.$loginPreset);

            this.subBlocks.loginPreset.focus();

            this.emit('hidePhone');

            this.val('login');
            this.validate(true); //To revalidate the subblocks
        },

        forcerNodeRepaint: function($el) {
            $el.addClass('js-fake-class-to-repaint');
            setTimeout(function() {
                $el.removeClass('js-fake-class-to-repaint');
            }, 0);
        },

        checkValidation: function(event, result) {
            var blockName = event && event.namespace;
            var block = passport.block(blockName);

            if (!block || (block.isEmpty() && !block.isRequired) || blockName === 'phone-confirm') {
                return;
            }

            block.$el.toggleClass('p-control_validated', result);
        },

        isLoginState: function() {
            return this.val() === 'login';
        },

        error: function(errors) {
            errors = [].concat(errors);
            this.parent.error.call(this, errors);
        },

        onSwitchToPhone: $.noop,
        onSwitchToLogin: $.noop
    });
})();
