var Field = require('pform/Field');

var QuestionField = require('../question/question.field');

/**
 * @extends Field
 */
var UserQuestionField = require('inherit')(Field, {
    __constructor: function() {
        this._init('user-question')
            .setName('hint_question')
            .setLabel('%field_hint_question')
            .addError(new Field.Error('missingvalue', '%hint_question_errors_missingvalue'))
            .addError(new Field.Error('toolong', '%hint_question_errors_toolong'));
    },

    isEmpty: function(formData) {
        if (!new QuestionField().isUserQuestion(formData)) {
            return false;
        }

        return !this._parseValue(formData);
    },

    onEmpty: function() {
        if (this.isRequired()) {
            this.getErrorByCode('missingvalue').setActive();
        }
    },

    onValid: function(formData) {
        this.setValue(this._parseValue(formData));
    }
});

module.exports = UserQuestionField;
