(function() {
    passport.block('user-question', 'control', {
        needsServerValidation: false,
        selectedQuestion: null,

        init: function() {
            this.selectedQuestion = passport.block('question').val();
            this.toggleState(this.isUserQuestion(this.selectedQuestion));
        },

        isUserQuestion: function(questionValue) {
            return questionValue === '99';
        },

        isEmpty: function() {
            return this.isUserQuestion(this.selectedQuestion) && this.parent.isEmpty.call(this);
        },

        events: {
            'update.question': 'onquestion'
        },

        getValidationParams: function() {
            var params = {};

            params[this.getHandleID()] = this.val();
            params[passport.block('question').getHandleID()] = passport.block('question').val();

            return params;
        },

        /**
         * Set the state for the control
         * @param {boolean} isUserQuestionSelected
         */
        toggleState: function(isUserQuestionSelected) {
            // No validations at all, if user question isn't selected
            this.needsServerValidation = isUserQuestionSelected;

            // Show/hide
            this.$el.toggleClass('g-hidden', !isUserQuestionSelected);
        },

        onquestion: function(evt, change) {
            var newState = change.shift();
            var isUserQuestionSelected = this.isUserQuestion(newState);
            var changed = isUserQuestionSelected !== this.isUserQuestion(this.selectedQuestion);

            this.selectedQuestion = newState;

            this.toggleState(isUserQuestionSelected);

            if (changed) {
                this.error();
                this.validate(!isUserQuestionSelected || this.isEmpty());
            }
        }
    });
})();
