/* borschik:include:../social/broker.js */

(function(window) {
    passport.block('domik', {
        events: {
            'click .js-scl-button': 'startSocialAuth',
            'click .js-domik-user-list-item-add': 'showMultiForm',
            'click .js-domik-user-list-item': 'changeDefaultAccount',
            'click .js-domik-user-list-item-logout': 'logoutAccount',
            'click .js-domik-user-logout': 'logoutAccount',
            'click .js-domik-user-list-item-edit': 'switchAccountsListToEdit',
            'click .js-domik-user-list-item-done': 'switchAccountsListToStatic'
        },

        _brokerParams: {},
        _viewName: null,
        _trailBrokerParams: ['from', 'domik'],

        lastAction: null,
        tld: null,
        avatarUrl: null,
        avatarRoofUrl: null,
        qrCodeLink: null,
        accountsHost: null,
        unreadPath: null,
        retpath: null,
        defaultData: {},
        currentUid: null,

        brokerOnSuccess: function() {
            if (this.retpath) {
                window.location.href = this.retpath;
            } else {
                if (this._viewName === 'auth.password_required') {
                    window.location = window.location.href;
                } else {
                    this.pageUpdate();
                    $('.js-error-isle').remove();
                }
            }
        },

        brokerOnFailure: function() {},

        startSocialAuth: function(event) {
            event.preventDefault();
            var elem = $(event.currentTarget);
            var provider = elem.data('provider');

            if (provider) {
                this.broker.start({
                    provider: provider
                });

                elem.blur();
            }
        },

        goToMagicFromSocial: function(login) {
            var link = '/auth?mode=qr&login=' + login;

            if (this.retpath) {
                link += '&retpath=' + this.retpath;
            }

            window.location.href = link;
        },

        setupBroker: function() {
            var that = this;
            var data = $('body').data();

            var query = passport.util.getUrlParams();

            this._trailBrokerParams.forEach(function(param) {
                if (query[param]) {
                    that._brokerParams[param] = query[param];
                }
            });

            if (this._viewName === 'auth.password_required') {
                this._brokerParams['track_id'] = $('#track_id').val();
                this._brokerParams['startUrl'] = '/auth/social/start_secure/';
            }

            if (data.origin !== '') {
                this._brokerParams['origin'] = data.origin;
            }

            if (passport.isTouch) {
                this._brokerParams.display = 'touch';
                this._brokerParams.retnopopup = this.retpath;
            }

            this.broker = passport.block('broker');
            this.broker.init(this._brokerParams);
        },

        setupPaths: function() {
            var data = $('body').data();

            // tld
            this.tld = data.tld || 'ru';

            // retath
            this.retpath = data.retpath || null;
            // accounts
            this.accountsHost = '//' + location.host + '/accounts-info';

            // avatars
            if (data.avatar && Object.keys(data.avatar).length) {
                this.avatarRoofUrl = '//' + data.avatar.host + data.avatar.pathname;
                this.avatarUrl = '//' + data.avatar.host + data.avatar.pathname;

                if (data.locals && data.locals.settings && data.locals.settings.intranet) {
                    this.avatarRoofUrl = this.avatarRoofUrl.replace(
                        '%size%',
                        window.devicePixelRatio > 1 ? '150' : '80'
                    );
                    this.avatarUrl = this.avatarUrl.replace('%size%', window.devicePixelRatio > 1 ? '85' : '42');
                } else {
                    this.avatarRoofUrl = this.avatarRoofUrl.replace(
                        '%size%',
                        window.devicePixelRatio > 1 ? 'retina-50' : '75'
                    );
                    this.avatarUrl = this.avatarUrl.replace(
                        '%size%',
                        window.devicePixelRatio > 1 ? 'retina-middle' : 'middle'
                    );
                }
            }

            // mail
            if (data.unread && Object.keys(data.unread).length) {
                this.unreadPath =
                    '//' + data.unread.host.replace('%tld%', this.tld) + data.unread.pathname + '?callback=?';
            }

            // qr_code_link
            this.qrCodeLink = $('.qr-code-link').attr('href');
        },

        setupMultiAuth: function() {
            var that = this;
            var $body = $('body');

            // res.locals
            this.defaultData = $body.data('locals') || {};

            if (this.defaultData.default_uid) {
                this.currentUid = this.defaultData.default_uid;
            }

            if (this.defaultData.fields && this.defaultData.fields.password) {
                delete this.defaultData.fields.password;
            }

            $body.removeAttr('data-locals');

            // default page view
            this._viewName = $('html').data('page-type');

            if (window.addEventListener) {
                window.addEventListener('message', that.multiAuthResponseHandle.bind(that), false);
            } else {
                window.attachEvent('onmessage', that.multiAuthResponseHandle.bind(that));
            }

            if (!window.location.origin) {
                window.location.origin = window.location.protocol + '//' + window.location.hostname;
            }

            window.socialResponse = function(data) {
                that.multiAuthResponseHandle({
                    // eslint-disable-next-line compat/compat
                    origin: location.origin,
                    data: data
                });
            };
        },

        parseAuthResponse: function(data) {
            var res = {};

            if (data) {
                if (data.socialAuth) {
                    res = data;
                } else {
                    var url = {};

                    if (typeof data === 'string') {
                        try {
                            url = JSON.parse(data);
                        } catch (e) {
                            /* jshint unused:false */
                        }
                    } else {
                        url = data;
                    }

                    if (url['async-auth']) {
                        res = passport.util.getUrlParams(url['async-auth']);
                    }
                }
            }

            return res;
        },

        multiAuthResponseHandle: function(event) {
            if (!window.location.origin) {
                window.location.origin = window.location.protocol + '//' + window.location.hostname;
            }

            if (event.origin !== window.location.origin) {
                return;
            }

            var response = this.parseAuthResponse(event.data);

            if (!Object.keys(response).length) {
                return;
            }

            if (response.socialAuth) {
                if (response.status === 'ok') {
                    this.brokerOnSuccess();
                }
                return;
            }

            if (response.status === 'sessionid-invalid') {
                window.location.reload();
                return;
            }

            var errors = (response.errors && decodeURIComponent(response.errors).split(',')) || [];

            if (
                response.status === 'other' &&
                response.magic === 'yes' &&
                this.qrCodeLink &&
                !passport.isTouch &&
                !passport.isTablet
            ) {
                window.location.href = this.qrCodeLink + '&reason=' + Date.now();
                return;
            }

            if (response.magic === 'yes' && errors.indexOf('password.not_matched') !== -1) {
                errors[errors.indexOf('password.not_matched')] = 'password-invalid_2fa';
            }

            if (response.status === 'other' && response.url) {
                this.redirectTo(decodeURIComponent(response.url));
                return;
            }

            if (['ok', 'action-not-required'].indexOf(response.status) >= 0) {
                this.pageUpdate();
            }

            if (this.lastAction === 'logout' && response.status === 'sessionid-no-uid') {
                this.pageUpdate();
            }

            if (response.status === 'captcha-required') {
                this.repaintCaptcha(response.captcha_url);
            }

            if (response.status === 'account-not-found') {
                this.repaintAccounts('add-user');
            }

            if (errors.length) {
                this.processError(errors);
            } else {
                this.processError([response.status]);
            }

            this.setIdKey(response.idkey || '');
            this.$('.js-submit-button').removeAttr('disabled');
        },

        setIdKey: function(key) {
            this.$('.js-multi-form-idkey').val(key);
        },

        getUid: function(event) {
            var elem = $(event.currentTarget);

            return elem.data('uid') || elem.parents('.domik-user-list-item').data('uid') || '';
        },

        getYaUid: function() {
            return passport.util.getCookie('yandexuid');
        },

        getAccounts: function() {
            var that = this;

            if (!this.accountsHost) {
                return;
            }

            return $.Deferred()
                .resolve()
                .then(function() {
                    return $.getJSON(that.accountsHost, {
                        yu: that.getYaUid(),
                        lang: that.defaultData.language || 'ru'
                    });
                });
        },

        internals: ['uid-empty'],

        errorsToLog: ['INVALID', 'DISABLED', 'DELETED'],

        errorIds: {
            'internal-exception': {
                msg: i18n('%ErrorsTexts.internal'),
                mend: i18n('%crap')
            },
            'password-invalid': {
                msg: i18n('%ErrorsTexts.badlog'),
                mend: i18n('%creg_misspasswd')
            },
            'password.not_matched': {
                msg: i18n('%ErrorsTexts.badlog'),
                mend: i18n('%creg_misspasswd')
            },
            'password-invalid_2fa': {
                msg: i18n('%ErrorsTexts.badlog_2fa'),
                mend: i18n('%creg_misspasswd_2fa')
            },
            'account-not-found': {
                msg: i18n('%ErrorsTexts.deleted'),
                mend: i18n('%deleted')
            },
            'account.not_found': {
                msg: i18n('%ErrorsTexts.deleted'),
                mend: i18n('%deleted')
            },
            DISABLED: {
                msg: i18n('%ErrorsTexts.badlog_blocked'),
                mend: i18n('%disabled')
            },
            INVALID: {
                msg: i18n('%session_invalid'),
                mend: i18n('%session_invalid_mend')
            }
        },

        showError: function(code) {
            if (
                ['captcha-invalid', 'captcha-captchalocate', 'captcha.invalid', 'captcha.captchalocate'].indexOf(
                    code
                ) !== -1
            ) {
                passport
                    .block('captcha')
                    .getNewCodeEmbeddedAuth()
                    .error('incorrect');
            }

            if (this.internals.indexOf(code) >= 0) {
                code = 'internal-exception';
            }

            if (code === 'sessionid-no-uid') {
                if (this.lastAction === 'logout') {
                    return;
                }

                if (this.lastAction === 'change_default') {
                    this.repaintDomik();
                    return;
                }
            }

            if (this.errorsToLog.indexOf(code) >= 0) {
                passport.api.log('ma domik error ' + code);
            }

            if (this.errorIds[code]) {
                $('.js-messages').html(
                    yr.run(
                        this._viewName,
                        {
                            errors: [
                                {
                                    code: code,
                                    msg: this.errorIds[code].msg || '',
                                    mend: this.errorIds[code].mend || ''
                                }
                            ]
                        },
                        'error-isle'
                    )
                );

                this.emit('errorShown', this.errorIds[code].msg || '');
            }
        },

        processError: function(errors) {
            var that = this;

            $('.js-error-isle').remove();

            [].concat(errors).forEach(function(code) {
                that.showError(code);
            });
        },

        redirectTo: function(url) {
            var a = document.createElement('a');

            a.href = location.href;
            a.pathname = '/redirect';
            a.search = '?url=' + encodeURIComponent(url);
            window.location.href = a.href;
        },

        repaintDomik: function(mode, redirectIfDefaultIsValid) {
            var that = this;

            $.when(this.getAccounts()).then(function(res) {
                if (
                    redirectIfDefaultIsValid &&
                    res.defaultAccount &&
                    res.defaultAccount.status === 'VALID' &&
                    that.retpath &&
                    that.lastAction !== 'logout'
                ) {
                    window.location.href = that.retpath;
                    return;
                }

                var data = {
                    avatarUrl: that.avatarUrl,
                    avatarRoofUrl: that.avatarRoofUrl,
                    domain: that.tld
                };

                if (res && res.accounts) {
                    data.accounts = res;
                    that.currentUid = res.default_uid;
                }

                if (that.lastAction === 'logout') {
                    data.mode = 'edit';
                }

                if (mode) {
                    data.mode = mode;
                }

                if (res.defaultAccount && res.defaultAccount.uid) {
                    //This is an ugly hack: pinning does not belongs inside a "repaint" operation
                    //But this is a place where we definitely know current user.
                    passport.pin(res.defaultAccount.uid);
                }

                if (res.defaultAccount && res.defaultAccount.status !== 'VALID') {
                    that.processError([res.defaultAccount.status]);
                }

                that.$el.html(yr.run(that._viewName, $.extend({}, that.defaultData, data), 'domik-inner'));

                that.$el.toggleClass('domik-wrap_accounts', Boolean(data.accounts));

                that.getMail();
                that.rebindEvents();
                that.$('.js-login-field, .js-passwd-field, .js-captcha-field').val('');
                that.$('input:visible')
                    .first()
                    .focus();
            });
        },

        repaintAccounts: function(mode) {
            var that = this;

            $.when(this.getAccounts()).then(function(res) {
                var data = {
                    avatarUrl: that.avatarUrl
                };

                if (that.lastAction === 'logout') {
                    data.mode = 'edit';
                }

                if (mode) {
                    data.mode = mode;
                }

                if (res && res.accounts) {
                    data.accounts = res;
                    that.$('.js-accounts').html(yr.run(that._viewName, data, 'accounts'));
                }
            });
        },

        repaintCaptcha: function(url) {
            var captchaParams = {
                control: {
                    id: 'captcha',
                    mode: 'text',
                    name: 'captcha_answer',
                    image_url: decodeURIComponent(url),
                    embedded: true,
                    label: i18n('%field_answer'),
                    error: [
                        {
                            code: 'missingvalue',
                            message: i18n('%answer_errors_missingvalue')
                        },
                        {
                            code: 'incorrect',
                            message: i18n('%answer_errors_incorrect')
                        }
                    ],
                    uatraits: this.defaultData.uatraits
                }
            };

            this.$('.js-domik-captcha').html(yr.run(this._viewName, captchaParams, 'captcha'));

            passport.block('captcha').construct($('*[data-block="p-control_captcha"]'));
            passport.validator.register(passport.ensureBlock('p-control_captcha'));

            if (/MSIE 8/.test(window.navigator.userAgent)) {
                this.$('.js-domik-scl').addClass('ie8-fix');
            }
        },

        rebindEvents: function() {
            Object.keys(passport.validator.store).forEach(function(item) {
                if (item !== 'captcha') {
                    passport.block(item).construct($('*[data-block="' + item + '"]'));
                }
            });
        },

        pageUpdate: function() {
            if (this.defaultData && this.defaultData.mode) {
                delete this.defaultData.mode;
            }

            this.repaintDomik(null, true);
        },

        showMultiForm: function() {
            this.repaintDomik('add-user');
        },

        hideMultiForm: function() {
            this.repaintDomik();
        },

        switchAccountsListToEdit: function() {
            this.repaintDomik('edit');
            passport.api.log('ma domik edit');
        },

        switchAccountsListToStatic: function() {
            this.lastAction = null;
            this.repaintDomik();
        },

        changeDefaultAccount: function(event) {
            this.submitMultiAuthForm(event, 'change_default');
        },

        logoutAccount: function(event) {
            this.submitMultiAuthForm(event, 'logout');
        },

        submitMultiAuthForm: function(event, action) {
            event.stopPropagation();

            var uid = this.getUid(event);

            if (!uid) {
                return;
            }

            this.$('.js-multi-form-uid').val(uid);
            this.$('.js-multi-form-yu').val(this.getYaUid());
            this.$('.js-multi-form-action').val(action);
            this.$('.js-multi-form').submit();
            this.lastAction = action;

            if (action === 'change_default' && this.currentUid === uid) {
                return;
            }

            passport.api.log('ma domik ' + action);
        },

        mailDict: {
            count: 0,
            none: i18n('%mail_empty'),
            one: i18n('%mail_inbox_one', '%count'),
            some: i18n('%mail_inbox_some', '%count'),
            many: i18n('%mail_inbox_many', '%count')
        },

        getMail: function() {
            var that = this;

            if (!this.unreadPath) {
                return;
            }

            if (!this.currentUid) {
                return;
            }

            $.getJSON(this.unreadPath, {
                key: passport.util.getCookie('yandexuid')
            }).done(function(data) {
                if (!data || !data.unread) {
                    return;
                }

                that.mailDict.count = data.unread;
                that.$('.js-domik-user-info-item_unread').text(
                    i18n.tanker.dynamic.plural_adv(that.mailDict).replace('%count', that.mailDict.count)
                );
            });
        },

        init: function() {
            this.setupPaths();
            this.setupMultiAuth();
            this.setupBroker();
            this.getMail();
        }
    });

    passport.block('login-auth', 'control', {
        needsServerValidation: false,

        events: {
            'keyup .js-login-field': 'toggleHint'
        },

        validate: function(supressError) {
            if (this.isEmpty()) {
                this.validationResult(false, 'missingvalue', supressError);
                return;
            }

            this.validationResult(true, null, true);
            this.error();
        }
    });

    passport.block('password-auth', 'control', {
        needsServerValidation: false,

        events: {
            'keyup .js-passwd-field': 'toggleHint'
        },

        validate: function(supressError) {
            if (this.isEmpty()) {
                this.validationResult(false, 'missingvalue', supressError);
                return;
            }

            if (passport.util.checkPassword(this.val())) {
                this.validationResult(true, 'lang', supressError);
                return;
            }

            this.validationResult(true, null, true);
            this.error();
        }
    });

    ['login-auth', 'password-auth', 'captcha'].forEach(function(control) {
        var block = passport.block(control);

        block.toggleHint = function(event) {
            var elem = event.currentTarget;
            var hint = this.$('.js-' + elem.id + '-control-hint');

            if (!hint) {
                return;
            }

            if (elem.value) {
                hint.addClass('g-hidden');
            } else {
                hint.removeClass('g-hidden');
            }
        };

        block.error = function(code) {
            if (['login-auth', 'password-auth'].indexOf(control) !== -1 && (passport.isTouch || passport.isTablet)) {
                if (code) {
                    this.$ctrl.addClass('domik-input__invalid');
                } else {
                    this.$ctrl.removeClass('domik-input__invalid');
                }

                return;
            }

            this.$('.domik-error-' + this.id).removeClass('b-popup_open');
            if (code) {
                this.$('.domik-error-' + this.id + '_' + code).addClass('b-popup_open');
            }

            if (code) {
                this.emit('errorShown', code);
            }
        };

        if (control === 'login-auth') {
            block.updateTimeout = 0;
        } else {
            block.updateTimeout = 50;
        }

        passport.mixins.validateOnFocusout(block);
    });
})(window);
