/* eslint-env node */

var config = require('../../configs/current');
var inherit = require('inherit');
var PView = require('pview');
var _ = require('lodash');
var restorePathsRegExp = new RegExp(/^\/restoration/);
var trimSlashesRegexp = /^\/+|\/+$/g;
var querystring = require('querystring');

module.exports = inherit(PView, {
    name: 'HelpLinkView',
    __constructor: function(controller) {
        this.__base.apply(this, arguments);
        this._controller = controller;
    },
    _compile: function() {
        var controller = this._controller;
        var url = controller.getUrl();
        var tld = controller.getTld();
        var customHelpLinkType = controller.getLocalsField('helpLinkType');
        var type = 'passport';
        var params = {};
        var helpLink = '';

        if (['az', 'com.am', 'com.ge', 'kg', 'md', 'tj', 'tm', 'uz'].indexOf(tld) > -1) {
            tld = 'ru';
        }

        if (['co.il', 'fr', 'lv', 'lt', 'ee', 'fi', 'pl', 'eu'].indexOf(tld) > -1) {
            tld = 'com';
        }

        if (!config.paths.help) {
            return {};
        }

        var helpLinks = _.clone(config.paths.help);

        if (url.query) {
            params = querystring.parse(url.query);
        }

        if (
            (url.pathname.replace(trimSlashesRegexp, '') === 'passport' && url.query && params.mode === 'spprtrstr') ||
            restorePathsRegExp.test(url.pathname)
        ) {
            type = 'restore';

            if (['/restoration/semi_auto', '/restoration/semi_auto/commit'].indexOf(url.pathname) !== -1) {
                type += '-semiauto';
            }
        }

        if (customHelpLinkType) {
            type = customHelpLinkType;
        }

        helpLink = helpLinks[type] && helpLinks[type].replace('%tld%', tld);

        if (!helpLink) {
            return {};
        }

        return {
            helpLink: helpLink
        };
    }
});
