/* eslint-env node */

const inherit = require('inherit');
const PView = require('pview');
const crypto = require('crypto');
const url = require('url');
const _ = require('lodash');

const MS_IN_A_DAY = 1000 * 86400;
const TRACK_ID_RE = /track_id/;

module.exports = inherit(PView, {
    name: 'LangSwitcherView',
    __constructor(controller, trackId) {
        this.__base.apply(this, arguments);
        this._controller = controller;
        this._track_id = trackId;
    },

    _days() {
        return Math.floor(Date.now() / MS_IN_A_DAY);
    },

    _md5(str) {
        return crypto
            .createHash('md5')
            .update(str)
            .digest('hex');
    },

    getSecretKey() {
        if (this._sk) {
            return this._sk;
        }

        /* var uid = this._controller.getAuth().getUid();
        if (uid) {
            this._sk = 'u' + this._md5(uid + '::' + this._days());
        } else {
            this._sk = 'y' + this._md5('0:' + this._controller.getCookie('yandexuid') + ':' + this._days());
        } */
        this._sk = `y${this._md5(`0:${this._controller.getCookie('yandexuid')}:${this._days()}`)}`;

        return this._sk;
    },

    getTuneLink() {
        const controller = this._controller;
        const link = controller.getUrl();

        let retpath = link.href;
        const track = controller.getRequestParam('track_id') || this._track_id;
        const currentTld = controller.getTld();
        const host = `yandex.${currentTld}`;
        const pathname = 'portal/set/lang/';

        if (track && (!link.query || !TRACK_ID_RE.test(link.query))) {
            retpath += link.query ? '&' : '?';
            retpath += `track_id=${track}`;
        }

        return {
            protocol: link.protocol,
            host,
            pathname,
            query: {
                sk: this.getSecretKey(),
                retpath
            }
        };
    },

    getLangs() {
        return this._controller.getLanglist();
    },

    formatedList(langlist) {
        const linkTemplate = this.getTuneLink();
        const langs = _.clone(langlist, true);

        return langs.map(function(lang) {
            const link = _.clone(linkTemplate);

            link.query.intl = lang.id;
            lang.link = url.format(link);
            return lang;
        });
    },

    _compile() {
        return this.getLangs().then((langlist) => {
            return {
                langlist: this.formatedList(langlist)
            };
        });
    }
});
