/* eslint-env node */

var CompositeView = require('./../../lib/views/CompositeView');
var inherit = require('inherit');

/**
 * A Page View matching the layout.yate
 * @extends {CompositeView}
 * @type {View} LayoutView
 */
module.exports = inherit(CompositeView, {
    /**
     * Creates a LayoutView responsible for working with layout.yate
     *
     * @constructs LayoutView
     *
     * @param {string} tld          Top level domain the page is displayed on, for example: com for yandex.com
     * @param {string} staticPath   Path to static files either relative to the page or a full url: '/st/'
     * @param {string} language     Two-letter language code
     * @param {string} track_id     Track id
     *
     * @param {object} [extra]      Extra parameters to be passed into the template
     * @param {object} [extra.logger_token]     A token used to access logger
     * @param {object} [extra.metrics_id]       An id of metrics counter
     *
     */

    //TODO: Page name is currently set by the render engine, remove it from render engine and accept it as a parameter
    __constructor: function(tld, staticPath, language, track_id, extra) {
        var assert = require('assert');

        assert(
            tld && typeof tld === 'string' && tld.charAt(0) !== '.',
            'Top level domain string required and should omit the dot'
        );
        assert(staticPath && typeof staticPath === 'string', 'StaticPath should be an url to static files root');
        assert(typeof language === 'string' && language.length === 2, 'Language should be a two-letter language code');
        assert(typeof track_id === 'string' && track_id.length > 0, 'Track id should be a string');
        assert(
            ['undefined', 'object'].indexOf(typeof extra) > -1,
            'Extra parameters should be passed as an object if defined'
        );

        this._tld = tld;
        this._lang = language;
        this._track_id = track_id;
        this._staticPath = staticPath;
        this._extraParams = extra;

        this.__base.apply(this, arguments);
    },

    compile: function() {
        var self = {
            domain: this._tld,
            language: this._lang,
            track_id: {
                id: this._track_id
            },
            config: {
                lang: this._lang,
                paths: {
                    static: this._staticPath
                }
            }
        };

        return require('lodash').merge(self, this._extraParams, this.__base.apply(this, arguments));
    }
});
