$(function() {
    init();

    function init() {
        var data = $('body').data();

        if (data.extendedLogging) {
            trackUserActions();
        }
    }

    function trackUserActions() {
        // focus/blur events don't bubble up, so we need to use focusin/focusout
        // but these events doesnt work in Firefox
        // @see https://bugzilla.mozilla.org/show_bug.cgi?id=687787
        var $document = $(document);

        if (document.addEventListener) {
            document.addEventListener('focus', onFocusInOut, true);
            document.addEventListener('blur', onFocusInOut, true);
        } else {
            $document.on('focusin', onFocusInOut);
            $document.on('focusout', onFocusInOut);
        }
        $document.on('keyup', onKeyDownUp);
        $document.on('keydown', onKeyDownUp);
        //$document.on('keypress', onKeyPress);
    }
    /**
     * Listen to focus/blur events and log field name and its value length
     */
    function onFocusInOut(e) {
        var field = e.target;
        var eventType = e.type.match(/^focus$|^focusin$/) ? 'focus' : 'blur';

        if (e.target.tagName === 'INPUT') {
            passport.api.log(
                {
                    action: 'field:' + eventType,
                    withTrackId: true,
                    field: {
                        name: field.name,
                        length: field.value.length
                    }
                },
                {
                    encrypt: true
                }
            );
        }
    }

    var isKeyDown = false;
    /**
     * Listen to keydown/up event and log pressed keys with modificators
     * format of the action is "key[down|up]:[symbol|tab|space|backspace|enter]"
     * logging is disabled for password fields
     */

    function onKeyDownUp(e) {
        if (e.target.type === 'password' || (e.type === 'keydown' && isKeyDown)) {
            return;
        }
        if (e.type === 'keydown') {
            isKeyDown = true;
        } else {
            isKeyDown = false;
        }
        var pressedModificators = [];
        var modificators = ['alt', 'ctrl', 'shift', 'meta'];
        var action = e.type + ':symbol';
        var keyCode = e.keyCode;
        var logObj;
        var keysMap = {
            '8': 'backspace',
            '9': 'tab',
            '13': 'enter',
            '32': 'space'
        };

        if (keyCode in keysMap) {
            action = e.type + ':' + keysMap[keyCode];
        }
        modificators.forEach(function(mod) {
            if (e[mod + 'Key']) {
                pressedModificators.push(mod);
            }
        });
        logObj = {
            action: action,
            withTrackId: true
        };
        if (pressedModificators.length !== 0) {
            logObj.modificators = pressedModificators;
        }
        passport.api.log(logObj, {
            encrypt: true
        });
    }
});
