passport.block('magic', {
    events: {
        'click .js-enable-inputs span': 'toggleOTP',
        'click .js-login-bt': 'stopPoll'
    },

    _viewName: null,
    _inputsEnabled: false,
    _interval: 300,
    _add_user_link: null,
    _stopped: true,

    _errorIds: {
        'internal-exception': {
            msg: i18n('%ErrorsTexts.internal'),
            mend: i18n('%crap')
        },
        'password.not_matched': {
            msg: i18n('%ErrorsTexts.badlog_2fa'),
            mend: i18n('%creg_misspasswd_2fa')
        },
        'account.not_found': {
            msg: i18n('%ErrorsTexts.deleted'),
            mend: i18n('%deleted')
        },
        'account.disabled_on_deletion': {
            msg: i18n('%ErrorsTexts.deleted'),
            mend: i18n('%deleted')
        },
        'account.disabled_with_money': {
            msg: i18n('%ErrorsTexts.deleted'),
            mend: i18n('%deleted')
        },
        'account.disabled': {
            msg: i18n('%ErrorsTexts.badlog_blocked'),
            mend: i18n('%disabled')
        },
        // 'captcha.required': {
        //     msg: i18n('%ErrorsTexts.badlog'),
        //     mend: i18n('%creg_misspasswd')
        // },
        'account.registration_limited': {
            msg: i18n('%import.sms_limit_exceeded')
        },
        internal: {
            msg: i18n('%ErrorsTexts.internal'),
            mend: i18n('%crap')
        },
        'sessionid.overflow': {
            msg: i18n('%ErrorsTexts.sessionidoverflow'),
            mend: i18n('%MendTexts.sessionidoverflow')
        },
        'session.invalid': {
            msg: i18n('%session_invalid'),
            mend: i18n('%session_invalid_mend')
        },
        'account.compromised': {
            msg: i18n('%ErrorsTexts.account_compromised')
        }
    },

    _showError: function(code) {
        var self = this;

        if (!this._errorIds[code]) {
            return;
        }

        $('.js-messages').html(
            yr.run(
                'auth.verify',
                {
                    errors: [
                        {
                            code: code,
                            msg: self._errorIds[code].msg || '',
                            mend: self._errorIds[code].mend || ''
                        }
                    ]
                },
                'error-isle'
            )
        );
    },

    _showCaptcha: function(captcha) {
        $('.js-domik-captcha').html(
            yr.run(
                'confirm',
                {
                    static: captcha.static,
                    control: [captcha]
                },
                'captcha'
            )
        );

        //this._rebindCaptchaEvents();
        //this._showCaptchaMsg();
        //this._hideMagic();
    },

    _showCaptchaMsg: function() {
        this.$('.js-captcha__msg').html(
            yr.run(
                'confirm',
                {
                    captchaMsg: i18n('%magic.captcha_msg')
                },
                'captcha-msg'
            )
        );
    },

    _rebindCaptchaEvents: function() {
        passport.block('captcha').construct($('*[data-block="p-control_captcha"]'));
        passport.validator.register(passport.ensureBlock('p-control_captcha'));
    },

    _hideMagic: function() {
        this.$('.js-magic-container').remove();
    },

    toggleOTP: function() {
        if (this._inputsEnabled) {
            return;
        }

        this.$('.js-enable-inputs').addClass('enable-inputs-link__hidden');
        this.$('.inputs').removeClass('inputs__hidden');
        this._inputsEnabled = true;

        this.$('input:visible')
            .first()
            .focus();
    },

    restartPolling: function() {
        var self = this;

        if (!self._stopped) {
            setTimeout(function() {
                self.poll();
            }, self._interval);
        }
    },

    poll: function() {
        var self = this;

        var req = $.ajax(self._handle || '/auth/magic/status/', {
            data: {
                track_id: self.track_id,
                csrf_token: self.csrf_token
            },
            dataType: 'json',
            type: 'POST'
        });

        req.done(function(results) {
            var captcha;
            var opts;

            if (results.status === 'ok' && results.state === 'otp_auth_finished') {
                window.location.href = '/auth/finish/?track_id=' + self.track_id;
                return;
            }

            if (results.errors) {
                self._showError(results.errors[0]);
                self.stop();
                //self.toggleOTP();

                if (results.errors.indexOf('captcha.required') !== -1) {
                    //self.stopPoll();
                    //self.stop();

                    captcha = results.captcha;
                    opts = captcha.options || (captcha.options = {});

                    opts.asyncCheck = true;
                    opts.popup = true;

                    self.emit('needCaptcha', captcha);

                    //$("body").append((yr.run('confirm', {
                    //    static: captcha.static,
                    //    control: [captcha]
                    //}, 'captcha')));
                    //
                    //$('*[data-block=control_captcha]').each(function() {
                    //    var block = passport.ensureBlock( $(this).attr('data-block') );
                    //
                    //    if (block) {
                    //        block.construct(this, $(this).data('options'));
                    //        console.log('Block "' + block.id + '" inited.');
                    //
                    //        if (block.isControl) {
                    //            passport.validator.register(block);
                    //        }
                    //    }
                    //});
                    //captchaBlock = passport.block('captcha');
                    //captchaBlock.updateTimeout = 0;
                    //captchaBlock.enableCaptcha();

                    //window.location.href = '/confirm/?track_id=' + self.track_id;
                    return;
                } else {
                    self.emit('genericError', captcha);
                }
            }

            self.restartPolling();
        });
    },

    stopPoll: function() {
        this._stopped = true;
    },

    stop: function() {
        clearTimeout(window.intervalTimeout);
        clearTimeout(window.redirectTimeout);

        this.stopPoll();
    },

    restart: function() {
        var self = this;

        self.stop();

        self._interval = 300;

        window.intervalTimeout = setTimeout(function() {
            self._interval = 1000;
        }, 60 * 1000);

        window.redirectTimeout = setTimeout(function() {
            window.location.reload(true);
        }, 60 * 1000 * 10);

        self._stopped = false;
        self.restartPolling();
    },

    init: function(options) {
        var self = this;

        self._add_user_link = $('.js-add_user_link');
        self._handle = options && options.handle;

        self.track_id = $('#track_id').val();
        self.csrf_token = $('#csrf_token').val();

        this.restart();
    }
});
