(function() {
    passport.block('restore-metrics', {
        headerMetrics: ['Восстановление доступа'],
        step: '',

        events: {
            'onSuggestItemClick.login-simple': 'onLoginSimpleSuggestItemClick',
            'onDunnoLoginClick.login-simple': 'onLoginSimpleDunnoLoginClick',
            'onEntry.login-simple': 'onLoginSimpleEntry',
            'onEntry.captcha': 'onCaptchaEntry',
            'onSubmit.submit': 'onFormSubmit',
            'onSubmit.hint-entry': 'onFormSubmit',
            'onSubmit.email-entry': 'onFormSubmit',
            'showEntry.phone-confirm': 'onPhoneConfirmShowEntry',
            'onEntry.phone-confirm-entry': 'onPhoneConfirmEntry',
            'codeSent.phone-confirm': 'onPhoneConfirmGetCode',
            'showAcknowledgement.phone-confirm': 'onPhoneConfirmShowAcknowledgement',
            'codeSent.phone-confirm-code': 'onPhoneConfirmGetCode',
            'retryCall.phone-confirm-code': 'onPhoneConfirmRetryCall',
            'retrySms.phone-confirm-code': 'onPhoneConfirmRetrySms',
            'onEntry.phone-confirm-code': 'onPhoneConfirmCodeEntry',
            'showEntry.hint-entry': 'onHintEntryShow',
            'onEntry.hint-entry': 'onHintEntry',
            'onEntry.email-entry': 'onEmailEntry',
            'showEntry.email-entry': 'onEmailEntryShow',
            'showRestoreMethods.restore-methods': 'onRestoreMethodsShowEntry',
            'onEntryPhone.restore-methods': 'onRestoreMethodsEntryPhone',
            'onEntryEmail.restore-methods': 'onRestoreMethodsEntryEmail',
            'showEntry.password': 'onPasswordEntryShow',
            'onEntry.password': 'onPasswordEntry',
            'onEntry.password-confirm': 'onPasswordConfirmEntry'
        },

        clearStep: function() {
            this.step = '';

            return this;
        },

        setStep: function(step) {
            if (step) {
                this.step = step;
            }
        },

        init: function(step, params) {
            this.setStep(step);

            if (params) {
                this.send(params);
            }

            $('.js-restore-footer-cant-restore').on('click', this.onCantRestoreClick.bind(this));
            $('.js-choose-method').on('click', this.onChooseMethodClick.bind(this));
            this.initEvents();
        },

        send: function(params) {
            passport.Metrika.count(this.headerMetrics.concat(this.step, params));
        },

        onLoginSimpleDunnoLoginClick: function() {
            this.send('Не помню логин');
        },

        onLoginSimpleSuggestItemClick: function() {
            this.send('Выбор логина из саджеста');
        },

        onLoginSimpleEntry: function() {
            this.send('Ввод логина');
        },

        onCaptchaEntry: function() {
            this.send('Ввод капчи');
        },

        onFormSubmit: function() {
            this.send('Далее');
        },

        onPhoneConfirmShowEntry: function() {
            this.send('Показ телефона');
            this.setStep('Показ телефона');
        },

        onPhoneConfirmEntry: function() {
            this.send('Ввод телефона');
        },

        onPhoneConfirmGetCode: function(event, number, isCall) {
            this.send(isCall ? 'Звонок' : 'Отправка кода');
        },

        onPhoneSuccessConfirm: function(byCall) {
            var msg = 'Успешное подтверждение через ';

            msg += byCall ? 'звонок' : 'смс';

            this.send(msg);
        },

        onPhoneConfirmRetryCall: function() {
            this.send('Повторный звонок');
        },

        onPhoneConfirmRetrySms: function() {
            this.send('Повторная отправка кода');
        },

        onCantRestoreClick: function() {
            this.send('Не получается восстановить');
        },

        onChooseMethodClick: function() {
            this.send('Другой способ восстановения');
        },

        onPhoneConfirmCodeEntry: function() {
            this.send('Ввод кода подтверждения');
        },

        onHintEntryShow: function() {
            this.send('Показ КВКО');
            this.setStep('Показ КВКО');
        },

        onHintEntry: function() {
            this.send('Ввод КВКО');
        },

        onRestoreMethodsShowEntry: function() {
            this.send('Показ выбора метода восстановения');
            this.setStep('Показ выбора метода восстановения');
        },

        onRestoreMethodsEntryEmail: function() {
            this.send('Выбор восстановления по емейлу');
        },

        onRestoreMethodsEntryPhone: function() {
            this.send('Выбор восстановления по телефону');
        },

        onEmailEntryShow: function() {
            this.send('Показ email');
            this.setStep('Показ email');
        },

        onEmailEntry: function() {
            this.send('Ввод email');
        },

        onPhoneConfirmShowAcknowledgement: function() {
            this.send('Телефон успешно подтвержден');
        },

        onPasswordEntryShow: function() {
            this.send('Показ смены пароля');
            this.setStep('Показ смены пароля');
        },

        onPasswordEntry: function() {
            this.send('Ввод пароля');
        },

        onPasswordConfirmEntry: function() {
            this.send('Ввод подтвреждения пароля');
        }
    });
})();
