/* global module */

(function(global, factory) {
    'use strict';

    if (typeof module === 'object' && module.exports) {
        module.exports = factory();
    } else {
        global.Monitoring = factory();
    }
})(this, function() {
    function merge() {
        var obj;
        var result = {};

        for (var i = 0; i < arguments.length; i++) {
            obj = arguments[i];

            if (typeof obj === 'object' && obj) {
                for (var key in obj) {
                    if (obj.hasOwnProperty(key)) {
                        result[key] = obj[key];
                    }
                }
            }
        }

        return result;
    }

    var Monitoring = {
        inited: false,
        _data: null,

        init: function(opts) {
            if (typeof window !== 'undefined') {
                this.inited = true;
                this._data = merge({app: 'passport'}, opts);
            }
        },

        send: function(params) {
            if (!this.inited) {
                return;
            }

            var queryParams = [];
            var data = merge(this._data, params, params.event === 'load' ? this.preparePerformanceData() : {});
            var xhr = window.XMLHttpRequest
                ? new window.XMLHttpRequest()
                : new window.ActiveXObject('Microsoft.XMLHTTP');

            for (var key in data) {
                if (data.hasOwnProperty(key)) {
                    queryParams.push(encodeURIComponent(key) + '=' + encodeURIComponent(data[key]));
                }
            }

            xhr.open('GET', '/monitoring' + '?' + queryParams.join('&'), true);
            xhr.withCredentials = true;
            xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
            xhr.send();
        },

        preparePerformanceData: function() {
            var pt;
            var pn;
            var data;

            if (
                !('performance' in window) ||
                !('timing' in window.performance) ||
                !('navigation' in window.performance)
            ) {
                return {};
            }

            pt = performance.timing; // eslint-disable-line compat/compat
            pn = performance.navigation; // eslint-disable-line compat/compat
            data = {
                'tm.navigationStart': pt.navigationStart,
                'tm.unloadEventStart': pt.unloadEventStart,
                'tm.unloadEventEnd': pt.unloadEventEnd,
                'tm.redirectStart': pt.redirectStart,
                'tm.redirectEnd': pt.redirectEnd,
                'tm.fetchStart': pt.fetchStart,
                'tm.domainLookupStart': pt.domainLookupStart,
                'tm.domainLookupEnd': pt.domainLookupEnd,
                'tm.connectStart': pt.connectStart,
                'tm.connectEnd': pt.connectEnd,
                'tm.secureConnectionStart': pt.secureConnectionStart,
                'tm.requestStart': pt.requestStart,
                'tm.responseStart': pt.responseStart,
                'tm.responseEnd': pt.responseEnd,
                'tm.domLoading': pt.domLoading,
                'tm.domInteractive': pt.domInteractive,
                'tm.domContentLoadedEventStart': pt.domContentLoadedEventStart,
                'tm.domContentLoadedEventEnd': pt.domContentLoadedEventEnd,
                'tm.domComplete': pt.domComplete,
                'tm.loadEventStart': pt.loadEventStart,
                'tm.loadEventEnd': pt.loadEventEnd,
                'nav.type': pn.type,
                'nav.redirectCount': pn.redirectCount
            };

            return data;
        }
    };

    return Monitoring;
});
