/* eslint-env node */

var PView = require('pview');
var inherit = require('inherit');
var url = require('url');
var _ = require('lodash');
var when = require('when');

module.exports = inherit(PView, {
    name: 'NavigationView',

    __constructor: function(controller) {
        this.__base.apply(this, arguments);
        this._controller = controller;
    },

    pages: ['retpath', 'personalinfo', 'access', 'emails', 'yasms', 'social', 'paymentinfo'],

    linksParams: {
        personalinfo: {},
        paymentinfo: 'https://money.yandex.%tld%/card/card-payment/about.xml',
        access: {
            query: null,
            pathname: '/profile/access'
        },
        yasms: {
            query: null,
            pathname: '/profile/phones'
        },
        social: {
            query: null,
            pathname: '/profile/social'
        },
        emails: {
            pathname: '/profile/emails',
            query: null
        },
        retpath: {
            search: null,
            pathname: '/redirect',
            query: {
                retpath: '/retpath'
            }
        }
    },

    checkRegExp: new RegExp(/\//g),

    isActive: function(code) {
        var currentPath = this._controller.getUrl().pathname;
        var pathToCheck = (this.linksParams[code] && this.linksParams[code].pathname) || '';

        if (!pathToCheck) {
            return false;
        }

        return pathToCheck.replace(this.checkRegExp, '') === currentPath.replace(this.checkRegExp, '');
    },

    getLink: function(code) {
        var tld = this._controller.getTld();
        var params = this.linksParams[code];
        var href = '';

        if (typeof params === 'string') {
            href = params.replace('%tld%', tld);
        } else {
            if (code === 'retpath') {
                params.query.retpath = this._controller.getRequestParam('retpath');
            }

            href = url.format(_.extend({}, this._controller.getModePassportUrl(), params));
        }

        return href;
    },

    getItem: function(code) {
        return {
            code: code,
            name: 'nav.' + code,
            href: this.getLink(code),
            active: this.isActive(code)
        };
    },

    getNavigation: function(uatraits) {
        var self = this;
        var pages = _.clone(this.pages);
        var nav = [];

        if (['kz', 'ua', 'by', 'ru'].indexOf(this._controller.getTld()) === -1) {
            pages = pages.filter(function(page) {
                return page !== 'paymentinfo';
            });
        }

        if (!this._controller.requestedWithRetpath() || !(uatraits.isTouch || uatraits.isMobile)) {
            pages.shift();
        }

        pages.forEach(function(page) {
            nav.push(self.getItem(page));
        });

        return when.resolve(nav);
    },

    _compile: function() {
        var self = this;

        return this._controller.getUatraits().then(function(uatraits) {
            return self.getNavigation(uatraits).then(function(navigation) {
                return {
                    navigation: navigation
                };
            });
        });
    }
});
