(function() {
    passport.block('navigation', {
        startX: null,
        currMargin: 0,

        disableScroll: false,

        events: {
            'touchstart .js-nav': 'touchStart',
            'touchmove .js-nav': 'touchMove',
            'touchend .js-nav': 'touchEnd'
        },

        touchStart: function(event) {
            if (!event) {
                return;
            }

            if (this.disableScroll) {
                return;
            }

            if (event.originalEvent.touches && event.originalEvent.touches[0]) {
                this.startX = (event.originalEvent.touches && event.originalEvent.touches[0].pageX) || null;
            }
        },

        touchMove: function(event) {
            if (!event) {
                return;
            }

            if (this.disableScroll) {
                return;
            }

            event.preventDefault();

            var shift = (event.originalEvent.touches && event.originalEvent.touches[0].pageX - this.startX) || 0;

            shift += this.currMargin;

            if (shift >= this.maxScrollBounce) {
                return;
            }

            if (shift <= this.maxMinusShift - this.maxScrollBounce) {
                return;
            }

            this.nav.css({
                marginLeft: shift
            });
        },

        touchEnd: function() {
            if (this.disableScroll) {
                return;
            }

            this.startX = null;
            this.testNavPosition();
        },

        testNavPosition: function() {
            this.currMargin = parseInt(this.nav.css('marginLeft'), 10);

            if (this.currMargin < this.maxMinusShift) {
                this.currMargin = this.maxMinusShift;
            }

            if (this.currMargin > 0 || this.disableScroll) {
                this.currMargin = 0;
            }

            this.scrollNav();
        },

        scrollNav: function() {
            var self = this;

            this.nav.addClass('nav__animate');
            this.nav.css({
                marginLeft: this.currMargin
            });

            setTimeout(function() {
                self.nav.removeClass('nav__animate');
            }, 300);
        },

        goToActive: function() {
            if (!passport.isTouch) {
                return;
            }

            var $active = this.$('.nav-item-link__active').parent('.js-nav-item');

            if (!$active.lenght) {
                return;
            }

            var activeOffset = $active.offset().left;

            if (this.hasRetpath) {
                activeOffset -= this.retpathOffset;
            } else {
                activeOffset -= 4.5;
            }

            this.currMargin = activeOffset * -1;
            this.scrollNav();
        },

        calcElemsWidth: function() {
            var elemsWidth = 0;

            this.$('.js-nav-item').each(function() {
                elemsWidth += $(this).outerWidth(true);
            });

            this.elemsWidth = elemsWidth;
        },

        calcMaxMinusShift: function() {
            var documentWidth = $(document).width();

            this.disableScroll = false;

            this.maxMinusShift = (this.elemsWidth - documentWidth + 10) * -1; // 10 - last margin

            if (this.elemsWidth <= documentWidth) {
                this.disableScroll = true;
            }
        },

        onResize: function() {
            if (!passport.isTouch) {
                return;
            }

            var self = this;

            setTimeout(function() {
                self.calcMaxMinusShift();
                self.testNavPosition();
            }, 10);
        },

        init: function() {
            this.nav = this.$('.js-nav');
            this.maxScrollBounce = 50; // for scroll bounce effect
            this.retpathOffset = 40;
            this.calcElemsWidth();
            this.calcMaxMinusShift();
            this.hasRetpath = this.$('.js-nav-item__retpath').length === 1;
            this.goToActive();

            $(window).on('resize', this.onResize.bind(this));
        }
    });
})();
