import api from '../../api';

export const ADD_DEVICE = 'ADD_DEVICE';
export const ADD_DEVICE_ERROR = 'ADD_DEVICE_ERROR';
export const ADD_DEVICE_FATAL_ERROR = 'ADD_DEVICE_FATAL_ERROR';
export const CLEAR_DEVICE_STATE = 'CLEAR_DEVICE_STATE';

export const submitDevice = (code) => (dispatch) => {
    api.request('/auth/device/submit', {code})
        .done((response) =>
            dispatch({
                type: ADD_DEVICE,
                payload: response
            })
        )
        .fail((err) => {
            const {errors} = err;

            if (!errors) {
                return dispatch({
                    type: ADD_DEVICE_FATAL_ERROR
                });
            }

            return dispatch({
                type: ADD_DEVICE_ERROR,
                payload: {error: errors[0]}
            });
        });
};

export const commitDevice = (code) => (dispatch) => {
    api.request('/auth/device/commit', {code})
        .done((response) =>
            dispatch({
                type: ADD_DEVICE,
                payload: response
            })
        )
        .fail((err) => {
            const {errors} = err;

            if (!errors) {
                return dispatch({
                    type: ADD_DEVICE_FATAL_ERROR
                });
            }

            return dispatch({
                type: ADD_DEVICE_ERROR,
                payload: {error: errors[0]}
            });
        });
};

export const clearDeviceState = () => (dispatch) => dispatch({type: CLEAR_DEVICE_STATE});
