import {connect} from 'react-redux';
import {AuthDevice} from './AuthDevice.jsx';
import {clearDeviceState, commitDevice, submitDevice} from '@blocks/AuthDevice/actions';

const mapStateToProps = (state = {}) => {
    const {settings = {}, authDevice = {}, access = {}} = state;
    const {error, shouldShowConfirmation, successAuth, title, shouldShowRestart} = authDevice;
    const {tld} = settings;

    return {
        tld,
        error,
        shouldShowConfirmation,
        successAuth,
        title,
        shouldShowRestart,
        access
    };
};

const mapDispatchToProps = {
    submitDevice,
    commitDevice,
    clearDeviceState
};

const ConnectedAuthDevice = connect(mapStateToProps, mapDispatchToProps)(AuthDevice);

export {ConnectedAuthDevice as AuthDevice};
