import {ADD_DEVICE, ADD_DEVICE_ERROR, CLEAR_DEVICE_STATE, ADD_DEVICE_FATAL_ERROR} from '../actions';

const initialState = {
    error: '',
    shouldShowConfirmation: false,
    shouldShowRestart: false,
    successAuth: false,
    title: ''
};

export const authDevice = (state = initialState, action) => {
    const {type, payload = {}} = action;
    const {shouldShowConfirmation, error, title} = payload;

    switch (type) {
        case ADD_DEVICE:
        case ADD_DEVICE_ERROR:
            return Object.assign({}, state, {
                error: error || '',
                successAuth: !shouldShowConfirmation && !error,
                shouldShowConfirmation: Boolean(shouldShowConfirmation),
                shouldShowRestart: false,
                title
            });

        case ADD_DEVICE_FATAL_ERROR:
            return Object.assign({}, initialState, {
                shouldShowRestart: true
            });

        case CLEAR_DEVICE_STATE:
            return initialState;

        default:
            return state;
    }
};
