import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {STEP_SCREENS} from '@blocks/UserEntryFlow/screens';

import './AuthRegComplete.styl';

const b = cn('AuthRegComplete');

export class AuthRegComplete extends React.PureComponent {
    static propTypes = {
        trackId: PropTypes.string,
        step: PropTypes.string,
        onNext: PropTypes.func.isRequired,
        prepareStep: PropTypes.func.isRequired,
        prepareStore: PropTypes.func.isRequired
    };

    componentDidMount() {
        const {prepareStep, prepareStore, step, trackId} = this.props;

        let promise = Promise.resolve();

        if (!step || !trackId) {
            promise = prepareStore();
        }

        promise.then(prepareStep);
    }

    _onNext = (event) => {
        event && event.preventDefault();
        this.props.onNext();
    };

    _getScreen() {
        const {step} = this.props;
        const Screen = STEP_SCREENS[step];

        return Screen && <Screen onConfirm={this._onNext} />;
    }

    render() {
        const {trackId} = this.props;

        return (
            <form autoComplete='off' method='post' onSubmit={this._onNext} className={b('form')}>
                {trackId && <input name='track_id' id='track_id' type='hidden' value={trackId} />}
                {this._getScreen()}
            </form>
        );
    }
}
