import {getFormValues, getTrackId} from '@blocks/selectors';
import {updateErrors} from '@blocks/actions/form';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {domikIsLoading} from '@blocks/auth/actions';
import {getError} from '@blocks/utils';
import {FIELDS_NAMES} from '@components/Field/names';
import api from '@blocks/api';
import metrika from '@blocks/metrics';

export function checkPhoneConfirmationCode() {
    return async (dispatch, getState) => {
        const state = getState();
        const trackId = getTrackId(state, TRACK_TYPES.COMMON);
        const values = getFormValues(state);

        try {
            await api.checkPhoneConfirmationCode({trackId, code: values.phoneCode});
        } catch (error) {
            const code = error.errors && error.errors[0];

            dispatch(updateErrors({field: FIELDS_NAMES.PHONE_CODE, error: getError(FIELDS_NAMES.PHONE_CODE, code)}));
            dispatch(domikIsLoading(false));
            metrika.send(`Показ ошибки поля phoneCode: ${code}`);
        }
    };
}
