import metrics from '@blocks/metrics';
import {domikIsLoading} from '@blocks/auth/actions';
import {getFormErrors} from '@blocks/selectors';
import {toggleHumanConfirmation} from '@blocks/authv2/actions/registration/toggleHumanConfirmation';
import sendConnectOrCompleteRegistrationData from '@blocks/registration/methods/sendConnectOrCompleteRegistrationData';
import {STEPS} from '@blocks/UserEntryFlow/steps';
import {getAuthRegCompleteConfig, getCurrentStep} from '@blocks/AuthRegComplete/logic';
import {FIELDS_NAMES} from '@components/Field/names';
import {getSuggestedLogins} from '@components/LoginSuggest/actions';
import {SECURITY_QUESTION_ID} from '@blocks/common/constants';
import {confirmPhone} from '@blocks/UserEntryFlow/logic';
import {moveNextStep} from './actions';
import {checkPhoneConfirmationCode} from './checkPhoneConfirmationCode';
import {validateSecurityAnswer} from './validateSecurityAnswer';
import {validationEmptyFields} from './validationEmptyFields';

function prepareFormData(state) {
    const {
        form: {
            values,
            type,
            captchaRequired,
            validation: {method}
        },
        common: {from},
        settings: {origin},
        person: {hasRecoveryMethod}
    } = state;
    const prepared = Object.assign({}, values);

    prepared.state = type;

    if (!captchaRequired && hasRecoveryMethod && prepared.hasOwnProperty('captcha')) {
        delete prepared.captcha;
    }

    // TODO нормально проверить что был шаг КВ КО
    if (method === 'captcha') {
        if (prepared.hint_question_id === SECURITY_QUESTION_ID.CUSTOM) {
            prepared.hint_question = prepared.hint_question_custom;
        }
    }

    if (typeof method !== 'undefined') {
        prepared['human-confirmation'] = method;
    }

    if (from) {
        prepared.from = from;
    }

    if (origin) {
        prepared.origin = origin;
    }

    return prepared;
}

export function onNext() {
    return async (dispatch, getState) => {
        const state = getState();
        const {form} = state;
        const authRegCompleteConfig = getAuthRegCompleteConfig(state);
        const currentStep = getCurrentStep(state);
        const currentStepConfig = authRegCompleteConfig[currentStep];
        const nextStep = currentStepConfig.next && currentStepConfig.next(state);

        metrics.send(`Клик "Далее" на экране ${currentStep}`);

        dispatch(domikIsLoading(true));

        try {
            await dispatch(validationEmptyFields());

            if (currentStep === STEPS.SQ_SA && form.states[FIELDS_NAMES.HINT_ANSWER] !== 'valid') {
                await dispatch(validateSecurityAnswer());
            }

            if (currentStep === STEPS.PHONE) {
                await dispatch(confirmPhone());
            }

            if (currentStep === STEPS.PHONE_CONFIRM) {
                await dispatch(checkPhoneConfirmationCode());
            }

            if (nextStep === STEPS.CAPTCHA) {
                dispatch(toggleHumanConfirmation('captcha'));
            }
        } catch (error) {
            // DO NOTHING
        }

        const errors = getFormErrors(getState());

        if (Object.values(errors).some(({code}) => code)) {
            dispatch(domikIsLoading(false));
            return;
        }

        if (nextStep === STEPS.LOGIN) {
            await getSuggestedLogins(dispatch, getState(), true);
        }

        if (nextStep) {
            dispatch(moveNextStep(currentStep, nextStep));
        }

        const isFinish = !nextStep;

        if (isFinish) {
            metrics.send(['Форма', 'Попытка отправки']);
            metrics.goal(`complete_v3_form_submitted`);

            const formData = prepareFormData(state);

            try {
                await dispatch(sendConnectOrCompleteRegistrationData(formData));
            } catch (error) {
                // DO NOTHING
            }
        }

        dispatch(domikIsLoading(false));
    };
}
