import {domikIsLoading} from '@blocks/auth/actions';
import {STEPS} from '@blocks/UserEntryFlow/steps';
import {getCurrentStep} from '@blocks/AuthRegComplete/logic';
import {getSuggestedLogins} from '@components/LoginSuggest/actions';

export function prepareStep() {
    return async (dispatch, getState) => {
        const state = getState();
        const currentStep = getCurrentStep(state);

        if (
            currentStep === STEPS.LOGIN &&
            !(state.logins && state.logins.loginsList && state.logins.loginsList.length)
        ) {
            dispatch(domikIsLoading(true));
            await getSuggestedLogins(dispatch, getState(), true);
            dispatch(domikIsLoading(false));
        }
    };
}
