import api from '@blocks/api';
import updateFieldStatus from '@blocks/registration/methods/updateFieldStatus';
import findFieldsWithErrors from '@blocks/registration/methods/findFieldsWithErrors';
import checkIfFieldEmpty from '@blocks/registration/methods/checkIfFieldEmpty';
import {errorsTxt} from '@blocks/registration/errors';
import {SECURITY_QUESTION_ID} from '@blocks/common/constants';

const getNormalizedFieldName = (fieldName) => (fieldName === 'hint_question' ? 'hint_question_custom' : fieldName);

export function validateSecurityAnswer() {
    return async (dispatch, getState) => {
        const state = getState();
        const track = state.common.track_id || state.tracks.registerTrackId;
        const {
            values: {hint_question_id, hint_question_custom, hint_answer}
        } = state.form;

        let requestData = {hint_answer, track_id: track};

        if (hint_question_id === SECURITY_QUESTION_ID.CUSTOM) {
            requestData = {...requestData, hint_question_id, hint_question: hint_question_custom};
        }

        const fieldNames = Object.keys(requestData);
        const emptyFieldValidationResult = fieldNames.map((fieldName) => {
            const errors =
                fieldName === 'hint_question' ? errorsTxt.hint.hintQuestionErrors : errorsTxt.hint.hintAnswerErrors;

            return checkIfFieldEmpty(requestData[fieldName], getNormalizedFieldName(fieldName))(dispatch, {
                code: 'missingvalue',
                text: errors.missingvalue
            });
        });

        if (emptyFieldValidationResult.some(Boolean)) {
            throw undefined;
        }

        try {
            const response = await api.request('answer', requestData);

            response.validation_errors &&
                response.validation_errors.map((error) => {
                    const fieldName = error.field;
                    const errors =
                        fieldName === 'hint_question'
                            ? errorsTxt.hint.hintQuestionErrors
                            : errorsTxt.hint.hintAnswerErrors;
                    const errorObj = {
                        code: error.code,
                        text: errors[error.code]
                    };

                    updateFieldStatus(getNormalizedFieldName(fieldName), 'not_valid')(dispatch, errorObj);
                });

            fieldNames.forEach((fieldName) => {
                if (response[fieldName]) {
                    updateFieldStatus(getNormalizedFieldName(fieldName), 'valid')(dispatch, getState);
                    dispatch(findFieldsWithErrors());
                }
            });

            if (response.validation_errors && response.validation_errors.length) {
                throw undefined;
            }
        } catch (error) {
            const errorObj = {
                code: 'global',
                text: errorsTxt.global && errorsTxt.global.errors && errorsTxt.global.errors.global
            };

            fieldNames.forEach((fieldName) => {
                updateFieldStatus(getNormalizedFieldName(fieldName), 'not_valid')(dispatch, errorObj);
            });

            throw undefined;
        }
    };
}
