import metrika from '@blocks/metrics';
import {getFields} from '@blocks/UserEntryFlow/steps';
import {getFormErrors, getFormValues} from '@blocks/selectors';
import {getError} from '@blocks/utils';
import {updateErrors} from '@blocks/actions/form';
import {getCurrentStep} from '@blocks/AuthRegComplete/logic';

export function validationEmptyFields() {
    return async (dispatch, getState) => {
        const state = getState();
        const step = getCurrentStep(state);
        const fields = getFields(step, state);
        const values = getFormValues(state);
        const errors = getFormErrors(state);
        const formErrors = [];

        fields.forEach((field) => {
            if (!values[field] || (values[field] && !values[field].trim()) || (errors[field] && errors[field].code)) {
                formErrors.push({
                    field,
                    error: errors[field] && errors[field].code ? errors[field] : getError(field, 'missingvalue')
                });
                metrika.send(`Показ ошибки поля ${field}: missingvalue`);
            }
        });

        if (formErrors.length) {
            formErrors.forEach((error) => dispatch(updateErrors(error)));
            throw undefined;
        }
    };
}
