import {STEPS} from '@blocks/UserEntryFlow/steps';

/**
 * PERSONAL_DATA -> LOGIN -> PHONE -> PHONE_CONFIRM -> PASSWORD
 * PERSONAL_DATA -> LOGIN -> PHONE -> PHONE_CONFIRM -> CURRENT_PASSWORD
 * PERSONAL_DATA -> LOGIN -> SQ_SA -> CAPTCHA -> PASSWORD
 * PERSONAL_DATA -> LOGIN -> SQ_SA -> CAPTCHA -> CURRENT_PASSWORD
 * PERSONAL_DATA -> LOGIN -> PASSWORD
 * PERSONAL_DATA -> LOGIN -> CURRENT_PASSWORD
 * LOGIN -> PHONE -> PHONE_CONFIRM -> PASSWORD
 * LOGIN -> PHONE -> PHONE_CONFIRM -> CURRENT_PASSWORD
 * LOGIN -> SQ_SA -> CAPTCHA -> PASSWORD
 * LOGIN -> SQ_SA -> CAPTCHA -> CURRENT_PASSWORD
 * LOGIN -> PASSWORD
 * LOGIN -> CURRENT_PASSWORD
 */
export const defaultCompleteLite = {
    firstStep: ({customs = {}}) =>
        customs.completeReg && customs.completeReg.skipPersonalData ? STEPS.LOGIN : STEPS.PERSONAL_DATA,
    [STEPS.PERSONAL_DATA]: {
        next: () => STEPS.LOGIN
    },
    [STEPS.LOGIN]: {
        next: ({person = {}}) =>
            !person.hasRecoveryMethod
                ? STEPS.PHONE
                : person.isLiteWithoutPassword
                ? STEPS.PASSWORD
                : STEPS.CURRENT_PASSWORD
    },
    [STEPS.PHONE]: {
        next: (state, btnName) => (btnName === 'noPhone' ? STEPS.SQ_SA : STEPS.PHONE_CONFIRM)
    },
    [STEPS.PHONE_CONFIRM]: {
        next: ({person = {}}) => (person.isLiteWithoutPassword ? STEPS.PASSWORD : STEPS.CURRENT_PASSWORD)
    },
    [STEPS.SQ_SA]: {
        next: () => STEPS.CAPTCHA
    },
    [STEPS.CAPTCHA]: {
        next: ({person = {}}) => (person.isLiteWithoutPassword ? STEPS.PASSWORD : STEPS.CURRENT_PASSWORD)
    },
    [STEPS.PASSWORD]: {},
    [STEPS.CURRENT_PASSWORD]: {}
};
