import {STEPS} from '@blocks/UserEntryFlow/steps';

/**
 * PERSONAL_DATA -> PHONE -> PHONE_CONFIRM -> PASSWORD
 * PERSONAL_DATA -> SQ_SA -> CAPTCHA -> PASSWORD
 * PERSONAL_DATA -> PASSWORD
 * PHONE -> PHONE_CONFIRM -> PASSWORD
 * SQ_SA -> CAPTCHA -> PASSWORD
 * PASSWORD
 */
export const defaultCompleteSocial = {
    firstStep: ({customs = {}, person = {}, form = {}}) => {
        if (customs.completeReg && customs.completeReg.skipPersonalData) {
            if (person.hasRecoveryMethod) {
                return STEPS.PASSWORD;
            } else {
                if (form.validation.method === 'phone') {
                    return STEPS.PHONE;
                } else {
                    return STEPS.SQ_SA;
                }
            }
        } else {
            return STEPS.PERSONAL_DATA;
        }
    },
    [STEPS.PERSONAL_DATA]: {
        next: ({person = {}}) => (!person.hasRecoveryMethod ? STEPS.PHONE : STEPS.PASSWORD)
    },
    [STEPS.PHONE]: {
        next: (state, btnName) => (btnName === 'noPhone' ? STEPS.SQ_SA : STEPS.PHONE_CONFIRM)
    },
    [STEPS.PHONE_CONFIRM]: {
        next: () => STEPS.PASSWORD
    },
    [STEPS.SQ_SA]: {
        next: () => STEPS.CAPTCHA
    },
    [STEPS.CAPTCHA]: {
        next: () => STEPS.PASSWORD
    },
    [STEPS.PASSWORD]: {}
};
