import {STEPS} from '@blocks/UserEntryFlow/steps';

/**
 * PERSONAL_DATA -> LOGIN -> PHONE -> PHONE_CONFIRM -> PASSWORD
 * PERSONAL_DATA -> LOGIN -> SQ_SA -> CAPTCHA -> PASSWORD
 * PERSONAL_DATA -> LOGIN -> PASSWORD
 * LOGIN -> PHONE -> PHONE_CONFIRM -> PASSWORD
 * LOGIN -> SQ_SA -> CAPTCHA -> PASSWORD
 * LOGIN -> PASSWORD
 */
export const defaultCompleteSocialWithLogin = {
    firstStep: ({customs = {}}) => {
        if (customs.completeReg && customs.completeReg.skipPersonalData) {
            return STEPS.LOGIN;
        } else {
            return STEPS.PERSONAL_DATA;
        }
    },
    [STEPS.PERSONAL_DATA]: {
        next: () => STEPS.LOGIN
    },
    [STEPS.LOGIN]: {
        next: ({person = {}}) => (!person.hasRecoveryMethod ? STEPS.PHONE : STEPS.PASSWORD)
    },
    [STEPS.PHONE]: {
        next: (state, btnName) => (btnName === 'noPhone' ? STEPS.SQ_SA : STEPS.PHONE_CONFIRM)
    },
    [STEPS.PHONE_CONFIRM]: {
        next: () => STEPS.PASSWORD
    },
    [STEPS.SQ_SA]: {
        next: () => STEPS.CAPTCHA
    },
    [STEPS.CAPTCHA]: {
        next: () => STEPS.PASSWORD
    },
    [STEPS.PASSWORD]: {}
};
