import {
    defaultCompleteAutoregistered,
    defaultCompleteLite,
    defaultCompleteNeophonish,
    defaultCompleteSocial,
    defaultCompleteSocialWithLogin
} from './configs';
import {
    AUTH_REG_COMPLETE_AUTOREGISTERED,
    AUTH_REG_COMPLETE_LITE,
    AUTH_REG_COMPLETE_NEOPHONISH,
    AUTH_REG_COMPLETE_SOCIAL,
    AUTH_REG_COMPLETE_SOCIAL_WITH_LOGIN
} from './constants';

const defaultMapConfig = {
    [AUTH_REG_COMPLETE_AUTOREGISTERED]: defaultCompleteAutoregistered,
    [AUTH_REG_COMPLETE_LITE]: defaultCompleteLite,
    [AUTH_REG_COMPLETE_NEOPHONISH]: defaultCompleteNeophonish,
    [AUTH_REG_COMPLETE_SOCIAL]: defaultCompleteSocial,
    [AUTH_REG_COMPLETE_SOCIAL_WITH_LOGIN]: defaultCompleteSocialWithLogin
};

export function getAuthRegCompleteConfig(state) {
    const config = defaultMapConfig[state.form.type];

    return {...config};
}
