import {COME_BACK_STEP, MOVE_NEXT_STEP} from '@blocks/AuthRegComplete/actions';

const initialState = {
    breadcrumbs: [],
    step: undefined,
    isCaptchaRequired: false
};

export function completeFlow(state = initialState, action = {}) {
    const {type, payload = {}} = action;

    switch (type) {
        case COME_BACK_STEP: {
            if (state.breadcrumbs.length) {
                const step = state.breadcrumbs[state.breadcrumbs.length - 1];
                const breadcrumbs = state.breadcrumbs.slice(0, state.breadcrumbs.length - 1);

                return {...state, step, breadcrumbs};
            }

            return state;
        }
        case MOVE_NEXT_STEP: {
            const {currentStep, nextStep} = payload;
            const breadcrumbs = [...state.breadcrumbs, currentStep];

            return {...state, step: nextStep, breadcrumbs};
        }

        default: {
            return state;
        }
    }
}
