import React, {useCallback} from 'react';
import {push} from 'react-router-redux';
import {useSelector, useDispatch} from 'react-redux';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {updateLoginValue} from '@blocks/authv2/actions';
import changeNativeInputValue from '@blocks/authv2/actions/changeNativeInputValue';

import './AuthRegPreComplete.styl';

const b = cn('AuthRegPreComplete');

export const AuthRegPreComplete = () => {
    const dispatch = useDispatch();
    const hasUnitedAccounts = useSelector(
        (state) => Object.keys((state.auth && state.auth.unitedAccounts) || {}).length > 0
    );
    const regCompleteUrl = useSelector((state) => state.common && state.common.regCompleteUrl);
    const addUserUrl = useSelector((state) => state.common && state.common.addUserUrl);
    const editUrl = useSelector((state) => state.common && state.common.editUrl);

    const onClick = useCallback(() => {
        dispatch(push(hasUnitedAccounts ? editUrl : addUserUrl, {isPreviousStep: true}));

        if (!hasUnitedAccounts) {
            dispatch(updateLoginValue(''));
            dispatch(changeNativeInputValue('login', ''));
        }
    }, [hasUnitedAccounts, editUrl, addUserUrl, dispatch]);

    return (
        <div className={b()}>
            <div className={b('image')} />
            <div className={b('title')}>{i18n('_Auth_.preregcomplete.title')}</div>
            <div className={b('description')}>{i18n('_Auth_.preregcomplete.description')}</div>
            <div className={b('controls')}>
                <Button
                    type='link'
                    url={regCompleteUrl}
                    text={i18n('_Auth_.preregcomplete.complete')}
                    width={'max'}
                    view='action'
                    size='l'
                />
                <Button
                    type='button'
                    text={i18n('Frontend.magic.return_to_auth')}
                    theme='normal'
                    width={'max'}
                    onClick={onClick}
                    view='transparent'
                    size='l'
                />
            </div>
        </div>
    );
};
