import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';

const b = cn('AuthSilent');

export class AuthSilent extends React.PureComponent {
    static propTypes = {
        url: PropTypes.string.isRequired
    };

    render() {
        return (
            <div className={b()}>
                <Button
                    type='link'
                    url={this.props.url}
                    target='_blank'
                    text={i18n('_AUTH_.sign_in')}
                    width='max'
                    size='l'
                />
            </div>
        );
    }
}
