export const magicService = {
    init({doneCallback, failCallback, trackId, csrfToken}) {
        this._doneCallback = doneCallback;
        this._failCallback = failCallback;
        this.trackId = trackId;
        this.csrfToken = csrfToken;
    },

    poll() {
        const req = $.ajax('/auth/new/magic/status/', {
            data: {
                track_id: this.trackId,
                csrf_token: this.csrfToken
            },
            dataType: 'json',
            timeout: 10000,
            type: 'POST'
        });

        req.fail(() => {
            if (this.timeoutErrorCount > 1) {
                this.stop();
                this._failCallback({error: 'global'});
            }

            this.timeoutErrorCount++;
            this.restartPolling();
        });

        req.done((results) => {
            if (results.status === 'ok') {
                this.stop();
                this._doneCallback(results);
                return;
            } else if (results.errors) {
                this.stop();
                this._failCallback({...results, error: results.errors[0]});
                return;
            }

            this.restartPolling();
        });
    },

    restartPolling() {
        if (!this._stopped) {
            setTimeout(() => {
                if (!this._stopped) {
                    this.poll();
                }
            }, this.interval);
        }
    },

    start() {
        this.restart();
    },

    restart() {
        this.trackNotFoundErrorCount = 0;
        this.timeoutErrorCount = 0;

        this.stop();

        this.interval = 300;

        this._intervalTimeout = setTimeout(() => {
            this.interval = 1000;
        }, 60 * 1000);

        this._stopped = false;
        this.restartPolling();
    },

    stopPoll() {
        this._stopped = true;
    },

    stop() {
        this.stopPoll();

        clearTimeout(window.intervalTimeout);
    }
};
