import React, {useCallback, useState} from 'react';
import {useSelector, shallowEqual, useDispatch} from 'react-redux';
import {cn} from '@bem-react/classname';
import {doCommitVerify} from '@blocks/AuthVerify/actions/doCommitVerify';
import {setCaptchaRequired} from '@blocks/actions/form';
import {Title} from '@components/Title';
import {Password} from '@components/Password';
import {Button} from '@components/Button';
import {FIELDS_NAMES} from '@components/Field/names';
import CurrentAccount from '@blocks/authv2/components/CurrentAccount/CurrentAccount.jsx';
import {Captcha} from '@blocks/Screens/Captcha';
import {Icon} from '@components/Icon';
import {getFormValues, getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {MagicScreen} from './MagicScreen';

import './AuthVerify.styl';

const b = cn('AuthVerify');

export const AuthVerify = () => {
    const dispatch = useDispatch();
    const [showQR, setShowQR] = useState(false);
    const {captchaRequired, login, trackId, isLoading} = useSelector((state) => {
        const {auth: {loading = false} = {}, form: {captchaRequired = false} = {}} = state;

        return {
            captchaRequired,
            login: getFormValues(state).login,
            trackId: getTrackId(state, TRACK_TYPES.COMMON),
            isLoading: loading
        };
    }, shallowEqual);

    const onQRClick = useCallback(() => {
        setShowQR(true);
    }, []);

    if (showQR) {
        return <MagicScreen setShowQR={setShowQR} />;
    }

    if (captchaRequired) {
        return (
            <Captcha
                onConfirmCallback={() => {
                    dispatch(setCaptchaRequired(false));
                }}
            />
        );
    }

    return (
        <form
            autoComplete='off'
            method='post'
            onSubmit={(event) => {
                event.preventDefault();
                dispatch(doCommitVerify());
            }}
            className={b()}
        >
            <div className={b('head')}>
                <Title>{i18n('Frontend.auth.verify.password.subheader')}</Title>
            </div>
            <CurrentAccount clickDisabled={true} />
            <input
                type='hidden'
                name={FIELDS_NAMES.LOGIN}
                id='login'
                readOnly={true}
                autoComplete='username'
                value={login}
            />
            <input name='track_id' id='track_id' type='hidden' value={trackId} />
            <div className={b('password')}>
                <Password
                    hideLabel={true}
                    shouldValidate={false}
                    view='big-input'
                    size='l'
                    options={{
                        autoCorrect: 'off',
                        autoCapitalize: 'off',
                        autoComplete: 'password'
                    }}
                />
            </div>
            <div className={b('controls')}>
                <Button width='auto' size='l' disabled={isLoading} view='pseudo' onClick={onQRClick}>
                    <Icon size='s' type='qr' withHover={false} />
                    <span>{i18n('_AUTH_.qr-code')}</span>
                </Button>
                <Button width='auto' text={i18n('_AUTH_.next')} size='l' disabled={isLoading} type='submit' />
            </div>
        </form>
    );
};
