import React, {useEffect} from 'react';
import PropTypes from 'prop-types';
import {useSelector, shallowEqual, useDispatch} from 'react-redux';
import {magicService} from '@blocks/AuthSilent/magicService';
import metrics from '@blocks/metrics';
import {cn} from '@bem-react/classname';
import errors from '@blocks/authv2/errors';
import {Link} from '@components/Link';
import {magicInit, updateMagicTokens} from '@blocks/authv2/actions/magic';
import MagicField from '@blocks/authv2/components/MagicField/MagicField.jsx';

import './MagicScreen.styl';

const b = cn('MagicScreen');

export function MagicScreen({setShowQR}) {
    const {csrfToken, trackId, fieldError} = useSelector((state) => {
        const {auth: {magicError, magicTrack: trackId, magicCSRF: csrfToken} = {}} = state;

        return {
            csrfToken,
            trackId,
            fieldError: (magicError && (errors[magicError] || errors.global)) || null
        };
    }, shallowEqual);
    const dispatch = useDispatch();

    useEffect(() => {
        metrics.send(['Показ QR кода ключа в /auth/verify']);

        if (!fieldError && csrfToken && trackId) {
            dispatch(magicInit());
        } else if (!fieldError) {
            dispatch(updateMagicTokens());
        }

        return () => {
            magicService.stop();
        };
    }, [dispatch, fieldError, csrfToken, trackId]);

    return (
        <>
            <h1 className={b('magicTitle')}>{i18n('_AUTH_.magic.enter_with_key')}</h1>
            <div className={b('magic')}>
                <MagicField trackId={trackId} fieldError={fieldError} icon='yandexKey' className={b('magicField')} />
                <div className={b('controls')}>
                    <Link onClick={() => setShowQR(false)} weight='medium'>
                        {i18n('Frontend.auth.verify__enter_password')}
                    </Link>
                </div>
            </div>
        </>
    );
}

MagicScreen.propTypes = {
    setShowQR: PropTypes.func.isRequired
};
