import metrika from '@blocks/metrics';
import {domikIsLoading} from '@blocks/auth/actions';
import {getFormValues} from '@blocks/selectors';
import {redirect} from '@blocks/authv2/actions';
import {getError} from '@blocks/utils';
import {updateErrors, setCaptchaRequired} from '@blocks/actions/form';
import api from '@blocks/api';

export function doCommitVerify() {
    return async (dispatch, getState) => {
        dispatch(domikIsLoading(true));

        const state = getState();
        const {password} = getFormValues(state);

        try {
            if (password === '') {
                metrika.send(`Показ ошибки поля current_password: missingvalue`);
                dispatch(
                    updateErrors({
                        field: 'current_password',
                        error: getError('current_password', 'missingvalue')
                    })
                );
                throw undefined;
            }

            const result = await api.request('auth-verify-commit', {
                password
            });

            const {redirectPath, status} = result;

            if (status === 'ok' && redirectPath) {
                return redirect(redirectPath);
            }
        } catch (err) {
            if (err && err.status === 'error' && Array.isArray(err.errors)) {
                const error = Array.isArray(err.errors) && err.errors[0];

                if (error === 'captcha.required') {
                    dispatch(setCaptchaRequired(true));
                } else {
                    metrika.send(`Показ ошибки поля current_password: ${error}`);
                    dispatch(
                        updateErrors({
                            field: 'password',
                            error: getError('password', error)
                        })
                    );
                }
            }
        }

        dispatch(domikIsLoading(false));
    };
}
