import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Button} from '@plibs/pcomponents/Button';
import metrika from '@blocks/metrics';

import './CheckData.styl';

const b = cn('CheckData');

const METRIC_EVENTS = {
    show: 'Новый домик v3/Аудит аккаунта',
    name: 'редактирование фио',
    phone: 'редактирование телефона',
    'phone-add': 'добавление телефона',
    email: 'редактирование email',
    'email-add': 'добавление email',
    question: 'редактирование контрольного вопроса',
    social: 'редактирование социальных сетей',
    ok: 'нажали на "все верно"'
};

const handleMetric = (event) => {
    const item = event && event.currentTarget && event.currentTarget.dataset.edit;

    if (item) {
        metrika.send(METRIC_EVENTS[item]);
    }
};
const renderAddLink = (item, links) => {
    return (
        <a
            href={links[item]}
            className={b('infoAddLink')}
            data-edit={`${item}-add`}
            target='_blank'
            onClick={handleMetric}
            rel='noopener noreferrer'
        >
            {i18n('OneDomik.CheckData.add')}
        </a>
    );
};
const renderEditLink = (item, links) => {
    return (
        <a
            href={links[item]}
            data-t={`editData-${item}`}
            data-edit={item}
            className={b('infoEditLink')}
            target='_blank'
            rel='noopener noreferrer'
            onClick={handleMetric}
        >
            {i18n('OneDomik.CheckData.edit')}
        </a>
    );
};

export class CheckData extends PureComponent {
    timerInterval = null;

    state = {
        delay: 5
    };

    componentDidMount() {
        metrika.send(METRIC_EVENTS.show);
        this.timerInterval = setInterval(() => {
            this.setState(({delay}) => ({delay: delay - 1}));
        }, 1000);
    }

    componentDidUpdate(prevProps, prevState) {
        if (prevState.delay <= 1) {
            clearInterval(this.timerInterval);
        }
    }

    componentWillUnmount() {
        clearInterval(this.timerInterval);
    }

    render() {
        const {personalInfo, retpath, isWarningIcon} = this.props;
        const {name, avatar, phone, email, social, question, links} = personalInfo;

        return (
            <div className={b('wrap')}>
                <div className={b('block', ['passp-auth'])} data-t='check-data'>
                    <div className={b('header')}>
                        <div className={b('headerLogo', {isWarningIcon: isWarningIcon})}>
                            <img
                                src={avatar}
                                width='72'
                                height='72'
                                alt={i18n('Frontend.new_avatars_current_avatar')}
                            />
                        </div>
                        <Title dataT='check-data-title'>{i18n('OneDomik.CheckData.title')}</Title>
                    </div>

                    <ul className={b('infoList')}>
                        {name && (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('OneDomik.CheckData.name')}</h4>
                                    <div className={b('infoText')}>{name}</div>
                                </div>
                                {renderEditLink('name', links)}
                            </li>
                        )}
                        {phone ? (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('_AUTH_.CheckData.phone')}</h4>
                                    <div className={b('infoText')}>{phone}</div>
                                </div>
                                {renderEditLink('phone', links)}
                            </li>
                        ) : (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('_AUTH_.CheckData.phone')}</h4>
                                    <div className={b('infoTextAdd')}>{i18n('OneDomik.CheckData.add-phone')}</div>
                                </div>
                                {renderAddLink('phone', links)}
                            </li>
                        )}
                        {email ? (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('OneDomik.CheckData.email')}</h4>
                                    <div className={b('infoText', {infoTextEmail: true})}>
                                        {email.map((item) => (
                                            <div key={item}>{item}</div>
                                        ))}
                                    </div>
                                </div>
                                {renderEditLink('email', links)}
                            </li>
                        ) : (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('OneDomik.CheckData.email')}</h4>
                                    <div className={b('infoTextAdd', 'add')}>
                                        {i18n('OneDomik.CheckData.add-email')}
                                    </div>
                                </div>
                                {renderAddLink('email', links)}
                            </li>
                        )}
                        {social && (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('OneDomik.CheckData.social')}</h4>
                                    <div className={b('infoText')}>
                                        {social.map((item) => (
                                            <div key={item}>
                                                <span
                                                    className={`CheckData-infoList-socialIcon p-icon__${item.provider}`}
                                                />
                                                {item.name}
                                            </div>
                                        ))}
                                    </div>
                                </div>
                                {renderEditLink('social', links)}
                            </li>
                        )}
                        {question && (
                            <li className={b('infoList-item')}>
                                <div className={b('infoList-content')}>
                                    <h4 className={b('infoTitle')}>{i18n('OneDomik.CheckData.question')}</h4>
                                    <div className={b('infoText')}>{question}</div>
                                </div>
                                {renderEditLink('question', links)}
                            </li>
                        )}
                    </ul>

                    <div data-t='check-data-submit' className={b('goRetpathBtn')}>
                        <Button
                            url={retpath}
                            type='link'
                            view='action'
                            size='l'
                            width='max'
                            onClick={this.handleMetric}
                            data-edit='ok'
                            disabled={this.state.delay > 0}
                        >
                            {i18n('OneDomik.CheckData.ok')}
                            {this.state.delay > 0 && (
                                <span className={b('delayTimer')}>{`00:0${this.state.delay}`}</span>
                            )}
                        </Button>
                    </div>
                </div>
            </div>
        );
    }
}

CheckData.propTypes = {
    retpath: PropTypes.string.isRequired,
    personalInfo: PropTypes.shape({
        avatar: PropTypes.string,
        name: PropTypes.string,
        phone: PropTypes.string,
        email: PropTypes.array,
        social: PropTypes.array,
        question: PropTypes.string,
        links: PropTypes.object
    }),
    isWarningIcon: PropTypes.bool
};
