import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {DownArrowIcon} from '@blocks/Components/DownArrowIcon';
import './AccountSelect.styl';

const b = cn('AccountSelect');

export class AccountSelect extends PureComponent {
    static propTypes = {
        avatarImageUrl: PropTypes.string.isRequired,
        className: PropTypes.string,
        hasPlus: PropTypes.bool,
        login: PropTypes.string.isRequired,
        onClick: PropTypes.func.isRequired
    };

    render() {
        const {avatarImageUrl, login, onClick, className, hasPlus} = this.props;

        return (
            <button className={b('', [className])} onClick={onClick}>
                <span
                    className={b('avatar', {
                        plus: hasPlus
                    })}
                    style={{backgroundImage: avatarImageUrl}}
                />
                <span className={b('login')}>{login}</span>
                <span className={b('iconWrapper')}>
                    <DownArrowIcon className={b('icon')} />
                </span>
            </button>
        );
    }
}
