export function mapStateToProps(state) {
    const {
        settings: {avatar: avatarSettings},
        auth: {processedAccount, defaultAccount}
    } = state;
    const account = processedAccount || defaultAccount || {};
    const {avatarId, login, mail, defaultEmail, hasPlus} = account;
    const {host, pathname} = avatarSettings;
    const avatarPathname = pathname
        .replace('%uid%', avatarId)
        .replace('%size%', '200')
        .replace('%login%', login);

    return {
        avatarImageUrl: `url("https://${host}${avatarPathname}")`,
        login: login || mail || defaultEmail || '',
        hasPlus
    };
}
