import {connect} from 'react-redux';
import {AccountsListItem as AccountsListItemComponent} from './AccountsListItem.jsx';
import {hasExp} from '@blocks/selectors';
import {RegType} from '@blocks/authv2/nativeMobileApi/constants';

const mapStateToProps = (state = {}) => {
    const {settings = {}, am: {regType} = {}} = state;
    const {avatar = {}} = settings;
    const {default_300} = avatar;

    return {
        defaultAvatarUrl: default_300,
        useNewSuggestByPhone: hasExp(state, 'use-new-suggest-by-phone') || regType === RegType.DOREGISH
    };
};

export const AccountsListItem = connect(mapStateToProps)(AccountsListItemComponent);
