import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import * as extrated from './AnimatedPages.js';

export default class AnimatedPages extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            currentPageIndex: 0,
            height: 'auto'
        };
    }

    componentWillReceiveProps({activePageIndex}) {
        if (activePageIndex !== this.props.activePageIndex) {
            extrated.fadeNextPage.call(this);
        }
    }

    render() {
        const {children, activePageIndex} = this.props;
        const {currentPageIndex, height} = this.state;

        return (
            <div className='a-page' style={{height}}>
                <div
                    className={classnames('a-page__child', {
                        'a-page__fadeout_top': currentPageIndex > activePageIndex,
                        'a-page__fadeout_bottom': currentPageIndex < activePageIndex
                    })}
                    key={currentPageIndex}
                    ref={(page) => {
                        this.currentPage = page;
                    }}
                >
                    {children[currentPageIndex]}
                </div>
                {activePageIndex !== currentPageIndex && (
                    <div
                        className={classnames('a-page__child', {
                            'a-page__fadein_top': currentPageIndex > activePageIndex,
                            'a-page__fadein_bottom': currentPageIndex < activePageIndex
                        })}
                        key={activePageIndex}
                        ref={(page) => {
                            this.activePage = page;
                        }}
                    >
                        {children[activePageIndex]}
                    </div>
                )}
            </div>
        );
    }
}

AnimatedPages.propTypes = {
    children: PropTypes.arrayOf(PropTypes.element).isRequired,
    activePageIndex: PropTypes.number.isRequired
};
