/* eslint-disable no-invalid-this */

export function constructState(props) {
    this.state = {
        contentHeight: props.isOpened ? 'auto' : 0
    };
}

export function recomputeHeight(isOpened) {
    const content = this.content;
    const contentHeight = content.offsetHeight || content.clientHeight;

    this.setState({contentHeight});
    clearTimeout(this.timer);
    if (isOpened) {
        this.timer = setTimeout(() => {
            this.setState({contentHeight: 'auto'});
        }, 350);
    } else {
        setTimeout(() => {
            this.setState({contentHeight: 0});
        }, 0);
    }
}
