import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import * as extracted from './AnimatedToggle.js';

export default class AnimatedToggle extends React.Component {
    constructor(props) {
        super(props);

        extracted.constructState.call(this, props);
    }

    componentWillReceiveProps({isOpened}) {
        if (isOpened !== this.props.isOpened) {
            extracted.recomputeHeight.call(this, isOpened);
        }
    }

    componentWillUnmount() {
        clearTimeout(this.timer);
    }

    render() {
        if (!this.props.children) {
            return null;
        }

        const height = this.state.contentHeight;

        return (
            <div
                className={classnames('a-toggle__wrapper', {
                    'a-toggle__visible': height
                })}
                style={{height}}
            >
                <div
                    className='a-toggle'
                    ref={(content) => {
                        this.content = content;
                    }}
                >
                    {this.props.children}
                </div>
            </div>
        );
    }
}

AnimatedToggle.propTypes = {
    children: PropTypes.oneOfType([PropTypes.element, PropTypes.arrayOf(PropTypes.element)]),
    isOpened: PropTypes.bool.isRequired
};
