import {connect} from 'react-redux';
import {AuthLoginInputToggle} from './AuthLoginInputToggle';
import {updateLoginValue, toggleLoginFieldType} from '@blocks/authv2/actions';
import {hasExp} from '@blocks/selectors';
import {FIELDS_NAMES} from '@components/Field/names';
import {getError} from '@blocks/utils';

const mapStateToProps = (state = {}) => {
    const {
        settings = {},
        auth: {form = {}, loginFieldType = 'login', loginError} = {},
        customs: {yaIdType = null} = {}
    } = state;
    const {tld} = settings;

    return {
        tld,
        phone: form.login,
        error: loginError && typeof loginError === 'string' ? getError(FIELDS_NAMES.PHONE, loginError) : '',
        fieldType: yaIdType || loginFieldType,
        isLoginMainExp: hasExp(state, 'auth-toggle-login-phone-exp'),
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
};

const mapDispatchToProps = {
    updateValue: updateLoginValue,
    toggleLoginFieldType
};

const ConnectedAuthLoginInputToggle = connect(mapStateToProps, mapDispatchToProps)(AuthLoginInputToggle);

export {ConnectedAuthLoginInputToggle as AuthLoginInputToggle};
