import './BackButton.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {classNames} from '@blocks/utils';

const b = classNames('BackButton');

export const BackButton = ({onClick, place, mode = 'back'}) =>
    !onClick ? null : <button type='button' tabIndex='-1' className={b('', {place, mode})} onClick={onClick} />;

BackButton.propTypes = {
    onClick: PropTypes.func,
    place: PropTypes.string,
    mode: PropTypes.oneOf(['back', 'close', 'arrowBack'])
};
