/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('BrokenIdIcon');

export const BrokenIdIcon = ({className}) => (
    <svg
        className={b('', [className])}
        width='56'
        height='56'
        viewBox='0 0 56 56'
        fill='none'
        xmlns='http://www.w3.org/2000/svg'
    >
        <path
            fillRule='evenodd'
            clipRule='evenodd'
            d='M24.7271 3.02955L25.1189 0.572021L24.4649 0.6466C23.9717 0.70283 23.0516 0.855571 22.1592 1.04501L22.0762 1.03198L22.0712 1.06383C21.5984 1.1657 21.1377 1.27736 20.7571 1.38986C20.739 1.39519 20.7208 1.4009 20.7024 1.40704C9.0564 4.60445 0.5 15.2667 0.5 27.9282C0.5 43.116 12.8122 55.4282 28 55.4282C43.1878 55.4282 55.4999 43.1161 55.5 27.9284L55.5 27.4284H52.5714L52.5714 27.9284C52.5711 41.4986 41.5702 52.4993 28 52.4993C26.5437 52.4993 25.117 52.3726 23.7303 52.1296L42.2562 24.4606L32.1093 23.2033L38.3186 5.62137C45.1667 8.79461 50.3077 15.029 51.9849 22.5666L52.0936 23.0552L54.952 22.4162L54.8435 21.9286C52.7657 12.5914 45.9421 5.04408 37.0351 1.94698L36.5628 1.78277L36.206 2.80896L28.1351 25.6619L37.1773 26.7823L25.3536 44.4413L29.4308 30.0064L20.6574 28.9624L24.7271 3.02955ZM21.5784 4.20389L17.293 31.5113L25.6807 32.5094L20.3752 51.2933C10.5374 48.085 3.42857 38.8366 3.42857 27.9278C3.42857 16.5794 11.1224 7.02713 21.5784 4.20389Z'
            fill='#262633'
        />
    </svg>
);

BrokenIdIcon.propTypes = {
    className: PropTypes.string
};
