import destroyAudioCaptcha from './destroyAudioCaptcha';
import playCaptcha from './playCaptcha';
import {getAudioCaptchaSuccess, getAudioCaptchaFail, changeCaptchaPlayStatus} from './';

export default function audioCaptchaInit(captcha) {
    return (dispatch) => {
        const Howl = window.Howl;
        const hasVoiceUrl = captcha.voice && captcha.voice.intro_url && captcha.voice.url;

        dispatch(destroyAudioCaptcha());

        if (!Howl || !hasVoiceUrl) {
            return dispatch(getAudioCaptchaFail());
        }

        let introSound = null;

        const introSoundPromise = new Promise((resolve, reject) => {
            introSound = new Howl({
                src: captcha.voice.intro_url,
                html5: true,
                preload: true,
                format: ['mp3']
            });

            introSound.on('load', () => resolve());
            introSound.on('loaderror', () => reject());
            introSound.on('end', () => dispatch(playCaptcha()));

            return introSound;
        });

        let captchaSound = null;

        const captchaSoundPromise = new Promise((resolve, reject) => {
            captchaSound = new Howl({
                src: captcha.voice.url,
                html5: true,
                preload: true,
                format: ['mp3']
            });

            captchaSound.on('load', () => resolve());
            captchaSound.on('loaderror', () => reject());
            captchaSound.on('end', () => dispatch(changeCaptchaPlayStatus(false)));

            return captchaSound;
        });

        return Promise.all([introSoundPromise, captchaSoundPromise])
            .then(() => dispatch(getAudioCaptchaSuccess(captcha.key, introSound, captchaSound)))
            .catch(() => dispatch(getAudioCaptchaFail()));
    };
}
